/*
 * Decompiled with CFR 0.152.
 */
package io.microlam.logging;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class JsonFormatter
extends Formatter {
    private final LogManager manager = LogManager.getLogManager();
    private final boolean useInstant;
    private final boolean oneNewLineOnly;

    public JsonFormatter() {
        this.useInstant = this.manager == null || this.getBooleanProperty(this.getClass().getName() + ".useInstant", true);
        this.oneNewLineOnly = this.manager == null || this.getBooleanProperty(this.getClass().getName() + ".oneNewLineOnly", false);
    }

    public JsonFormatter(boolean oneNewLineOnly) {
        this.useInstant = this.manager == null || this.getBooleanProperty(this.getClass().getName() + ".useInstant", true);
        this.oneNewLineOnly = oneNewLineOnly;
    }

    public JsonFormatter(boolean useInstant, boolean oneNewLineOnly) {
        this.useInstant = useInstant;
        this.oneNewLineOnly = oneNewLineOnly;
    }

    public boolean isUseInstant() {
        return this.useInstant;
    }

    public boolean isOneNewLineOnly() {
        return this.oneNewLineOnly;
    }

    protected boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder(500);
        sb.append("{\n");
        Instant instant = record.getInstant();
        sb.append("  \"date\" : \"");
        if (this.useInstant) {
            DateTimeFormatter.ISO_INSTANT.formatTo(instant, sb);
        } else {
            this.appendISO8601(sb, instant.toEpochMilli());
        }
        sb.append("\",\n");
        sb.append("  \"millis\" : ");
        sb.append(instant.toEpochMilli());
        sb.append(",\n");
        int nanoAdjustment = instant.getNano() % 1000000;
        if (this.useInstant && nanoAdjustment != 0) {
            sb.append("  \"nanos\" : ");
            sb.append(nanoAdjustment);
            sb.append(",\n");
        }
        sb.append("  \"sequence\" : ");
        sb.append(record.getSequenceNumber());
        sb.append(",\n");
        String name = record.getLoggerName();
        if (name != null) {
            sb.append("  \"logger\" : \"");
            this.escape(sb, name);
            sb.append("\",\n");
        }
        sb.append("  \"level\" : \"");
        this.escape(sb, record.getLevel().toString());
        sb.append("\",\n");
        if (record.getSourceClassName() != null) {
            sb.append("  \"class\" : \"");
            this.escape(sb, record.getSourceClassName());
            sb.append("\",\n");
        }
        if (record.getSourceMethodName() != null) {
            sb.append("  \"method\" : \"");
            this.escape(sb, record.getSourceMethodName());
            sb.append("\",\n");
        }
        sb.append("  \"thread\" : ");
        sb.append(record.getThreadID());
        if (record.getMessage() != null) {
            String message = this.formatMessage(record);
            sb.append(",\n  \"message\" : \"");
            this.escape(sb, message);
            sb.append("\"");
        }
        ResourceBundle bundle = record.getResourceBundle();
        try {
            if (bundle != null && bundle.getString(record.getMessage()) != null) {
                sb.append(",\n  \"key\" : \"");
                this.escape(sb, record.getMessage());
                sb.append("\",\n");
                sb.append("  \"catalog\" : \"");
                this.escape(sb, record.getResourceBundleName());
                sb.append("\"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] parameters = record.getParameters();
        if (parameters != null && parameters.length != 0 && record.getMessage().indexOf(123) == -1) {
            for (Object parameter : parameters) {
                sb.append(",\n  \"param\" : \"");
                try {
                    this.escape(sb, parameter.toString());
                }
                catch (Exception ex) {
                    sb.append("???");
                }
                sb.append("\"");
            }
        }
        if (record.getThrown() != null) {
            Throwable th = record.getThrown();
            sb.append(",\n  \"exception\" : {\n");
            sb.append("    \"message\" : \"");
            this.escape(sb, th.toString());
            sb.append("\"");
            StackTraceElement[] trace = th.getStackTrace();
            if (trace.length > 0) {
                sb.append(",\n");
                sb.append("    \"stacktrace\": [\n");
            }
            boolean start = true;
            for (StackTraceElement frame : trace) {
                if (!start) {
                    sb.append(",\n");
                }
                start = false;
                sb.append("    {\n");
                sb.append("      \"class\" : \"");
                this.escape(sb, frame.getClassName());
                sb.append("\",\n");
                sb.append("      \"method\" : \"");
                this.escape(sb, frame.getMethodName());
                sb.append("\"");
                if (frame.getLineNumber() >= 0) {
                    sb.append(",\n");
                }
                if (frame.getLineNumber() >= 0) {
                    sb.append("      \"line\" : ");
                    sb.append(frame.getLineNumber());
                    sb.append("\n");
                } else {
                    sb.append("\n");
                }
                sb.append("    }");
            }
            if (!start) {
                sb.append("\n    ]\n");
            }
            sb.append("  }\n");
        }
        sb.append("}\n");
        String result = sb.toString();
        return this.oneNewLineOnly ? result.replace('\n', '\r') + "\n" : result;
    }

    private void a2(StringBuilder sb, int x) {
        if (x < 10) {
            sb.append('0');
        }
        sb.append(x);
    }

    private void appendISO8601(StringBuilder sb, long millis) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        sb.append(cal.get(1));
        sb.append('-');
        this.a2(sb, cal.get(2) + 1);
        sb.append('-');
        this.a2(sb, cal.get(5));
        sb.append('T');
        this.a2(sb, cal.get(11));
        sb.append(':');
        this.a2(sb, cal.get(12));
        sb.append(':');
        this.a2(sb, cal.get(13));
    }

    private void escape(StringBuilder sb, String text) {
        if (text == null) {
            text = "null";
        }
        JsonFormatter.escape(text, sb);
    }

    static void escape(String s, StringBuilder sb) {
        int len = s.length();
        block10: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
    }
}

