/*
 * Decompiled with CFR 0.152.
 */
package io.microlam.logging;

import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.LambdaRuntime;
import io.microlam.logging.JsonFormatter;
import io.microlam.logging.OneLineSimpleFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class LambdaHandler
extends Handler {
    protected LambdaLogger lambdaLogger;
    protected ConsoleHandler consoleHandler;

    public LambdaHandler() {
        this(false);
    }

    public LambdaHandler(boolean useJsonFormatting) {
        this.setFormatter(useJsonFormatting ? new JsonFormatter() : new OneLineSimpleFormatter());
        this.lambdaLogger = LambdaRuntime.getLogger();
        this.consoleHandler = new ConsoleHandler();
        this.consoleHandler.setFormatter(useJsonFormatting ? new JsonFormatter(true) : new OneLineSimpleFormatter(true));
        this.consoleHandler.setLevel(this.getLevel());
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        if (this.lambdaLogger == null || record == null) {
            return false;
        }
        return super.isLoggable(record);
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (this.lambdaLogger != null && !this.lambdaLogger.getClass().getName().startsWith("com.amazonaws.services.lambda.runtime.LambdaRuntime$") && !this.lambdaLogger.getClass().getName().equals("com.amazonaws.services.lambda.runtime.api.client.logging.LambdaContextLogger")) {
            String msg;
            try {
                msg = this.getFormatter().format(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
                return;
            }
            try {
                this.lambdaLogger.log(msg);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 1);
            }
        } else {
            try {
                this.consoleHandler.publish(record);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 1);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

