/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata;

import io.pdfdata.DocumentsRequest;
import io.pdfdata.InfoRequest;
import io.pdfdata.JSON;
import io.pdfdata.ProcsRequest;
import io.pdfdata.ResourcesRequest;
import java.net.MalformedURLException;
import java.net.URL;

public class API {
    public static final String DEFAULT_API_ENDPOINT = "https://api.pdfdata.io/v1/";
    public static final URL API_ENDPOINT = API.endpoint_env();
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 80000;
    public static String VERSION = "0.9.3";
    private final String apiKey;
    private final URL endpoint;
    private int connectTimeout = 30000;
    private int readTimeout = 80000;
    private boolean captureResponseBodies = false;
    final JSON json;

    public API() {
        this(API.apikey_env(), API_ENDPOINT);
    }

    public API(String apiKey) {
        this(apiKey, API_ENDPOINT);
    }

    public API(URL endpoint) {
        this(API.apikey_env(), endpoint);
    }

    public API(String apiKey, URL endpoint) {
        this.apiKey = apiKey;
        this.endpoint = endpoint;
        this.json = new JSON(this);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getAPIKey() {
        return this.apiKey;
    }

    public URL getEndpoint() {
        return this.endpoint;
    }

    public boolean isCaptureResponseBodies() {
        return this.captureResponseBodies;
    }

    public void setCaptureResponseBodies(boolean captureResponseBodies) {
        this.captureResponseBodies = captureResponseBodies;
    }

    public DocumentsRequest documents() {
        return new DocumentsRequest(this);
    }

    public ProcsRequest procs() {
        return new ProcsRequest(this);
    }

    public ResourcesRequest resources() {
        return new ResourcesRequest(this);
    }

    public InfoRequest info() {
        return new InfoRequest(this);
    }

    private static URL newURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static URL newURL(URL base, String spec) {
        try {
            return new URL(base, spec);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static String apikey_env() {
        String apikey = API.environment("PDFDATA_APIKEY", null);
        if (apikey == null) {
            throw new IllegalStateException("You must provide an API key to use this library, either by passing it to a `io.pdfdata.API` constructor, or by setting the PDFDATA_APIKEY environment variable or system property.");
        }
        return apikey;
    }

    private static URL endpoint_env() {
        String url = API.environment("PDFDATA_ENDPOINT", DEFAULT_API_ENDPOINT);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(String.format("The `PDFDATA_ENDPOINT` system property / environment variable is set improperly: \"%s\" is not a valid URL", url), e);
        }
    }

    private static String environment(String variableName, String defaultValue) {
        String s = System.getProperty(variableName);
        if (s != null) {
            return s;
        }
        s = System.getenv(variableName);
        return s == null ? defaultValue : s;
    }
}

