/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Random;

public class MultipartProcessor {
    private final String boundary;
    private static final String LINE_BREAK = "\r\n";
    private OutputStream outputStream;
    private PrintWriter writer;
    private String charset;
    private HttpURLConnection conn;

    public static String getBoundary() {
        Random random = new Random();
        Long positiveRandomLong = Math.abs(random.nextLong());
        return String.valueOf(positiveRandomLong);
    }

    public MultipartProcessor(HttpURLConnection conn, String boundary, String charset) throws IOException {
        this.boundary = boundary;
        this.charset = charset;
        this.conn = conn;
        this.outputStream = conn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, charset), true);
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE_BREAK);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_BREAK);
        this.writer.append(LINE_BREAK);
        this.writer.append(value).append(LINE_BREAK);
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileField(String name, File file) throws IOException {
        String fileName = file.getName();
        this.writer.append("--" + this.boundary).append(LINE_BREAK);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"").append(LINE_BREAK);
        String probableContentType = URLConnection.guessContentTypeFromName(fileName);
        this.writer.append("Content-Type: " + probableContentType).append(LINE_BREAK);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_BREAK);
        this.writer.append(LINE_BREAK);
        this.writer.flush();
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.outputStream.write(buffer, 0, bytesRead);
            }
            this.outputStream.flush();
        }
        this.writer.append(LINE_BREAK);
        this.writer.flush();
    }

    public void finish() throws IOException {
        this.writer.append("--" + this.boundary + "--").append(LINE_BREAK);
        this.writer.flush();
        this.writer.close();
        this.outputStream.flush();
        this.outputStream.close();
    }
}

