/*
 * Decompiled with CFR 0.152.
 */
package io.pdfdata;

import io.pdfdata.API;
import io.pdfdata.JSON;
import io.pdfdata.PDFDATASSLSocketFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.bind.DatatypeConverter;

class Network {
    static final String CHARSET_NAME = "UTF-8";
    static final Charset CHARSET = Charset.forName("UTF-8");
    private static final SSLSocketFactory socketFactory = new PDFDATASSLSocketFactory();
    static boolean REQUIRE_SECURE_CONNECTIONS = true;
    private static final Map<String, String> BASE_HEADERS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("Accept-Charset", Network.CHARSET_NAME);
            this.put("Accept", "application/json");
            this.put("User-Agent", String.format("PDFDATA.io/v1 JavaBindings/%s", API.VERSION));
            this.put("X-API-Intent", "Y");
            String[] propertyNames = new String[]{"os.name", "os.version", "os.arch", "java.version", "java.vendor", "java.vm.version", "java.vm.vendor"};
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            for (String propertyName : propertyNames) {
                propertyMap.put(propertyName, System.getProperty(propertyName));
            }
            try {
                this.put("X-PDFDATA-Client-User-Agent", JSON.to0(propertyMap));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    });

    Network() {
    }

    public static Map<String, String> mergeHeaders(Map<String, String> additional) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(BASE_HEADERS);
        if (additional != null) {
            headers.putAll(additional);
        }
        return headers;
    }

    private static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String urlEncodePair(String k, String v) {
        return Network.urlEncode(k) + "=" + Network.urlEncode(v);
    }

    static String queryString(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder("?");
        for (Map.Entry<String, Object> param : params.entrySet()) {
            sb.append(Network.urlEncodePair(param.getKey(), String.valueOf(param.getValue())));
            sb.append("&");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static String base64(String s) {
        return DatatypeConverter.printBase64Binary((byte[])s.getBytes(CHARSET));
    }

    private static Map<String, String> getHeaders(API pdfdata) {
        HashMap<String, String> headers = new HashMap<String, String>(BASE_HEADERS);
        headers.put("Authorization", "Basic " + Network.base64(pdfdata.getAPIKey() + ":"));
        return headers;
    }

    static HttpURLConnection openConnection(Method verb, URL url, Map<String, String> headers, API pdfdata) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(socketFactory);
        } else if (REQUIRE_SECURE_CONNECTIONS) {
            throw new IOException("Could not establish secure connection to " + url);
        }
        conn.setRequestMethod(verb.toString());
        conn.setConnectTimeout(pdfdata.getConnectTimeout());
        conn.setReadTimeout(pdfdata.getReadTimeout());
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : Network.getHeaders(pdfdata).entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        if (verb == Method.POST) {
            conn.setDoOutput(true);
        }
        conn.connect();
        return conn;
    }

    public static enum Method {
        GET,
        POST;

    }
}

