/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import com.dylibso.chicory.experimental.hostmodule.annotations.HostModule;
import com.dylibso.chicory.experimental.hostmodule.annotations.WasmExport;
import com.dylibso.chicory.runtime.ExportFunction;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.runtime.WasmRuntimeException;
import com.dylibso.chicory.wasm.InvalidException;
import io.roastedroot.proxywasm.ForeignFunction;
import io.roastedroot.proxywasm.LogLevel;
import io.roastedroot.proxywasm.MetricType;
import io.roastedroot.proxywasm.QueueName;
import io.roastedroot.proxywasm.SharedData;
import io.roastedroot.proxywasm.WasmException;
import io.roastedroot.proxywasm.internal.Action;
import io.roastedroot.proxywasm.internal.ArrayProxyMap;
import io.roastedroot.proxywasm.internal.BufferType;
import io.roastedroot.proxywasm.internal.Handler;
import io.roastedroot.proxywasm.internal.Helpers;
import io.roastedroot.proxywasm.internal.MapType;
import io.roastedroot.proxywasm.internal.ProxyMap;
import io.roastedroot.proxywasm.internal.StreamType;
import io.roastedroot.proxywasm.internal.WasmResult;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@HostModule(value="env")
class ABI {
    private Handler handler;
    private Memory memory;
    ExportFunction initializeFn;
    ExportFunction mainFn;
    ExportFunction startFn;
    ExportFunction proxyOnContextCreateFn;
    ExportFunction proxyOnDoneFn;
    ExportFunction mallocFn;
    ExportFunction proxyOnLogFn;
    ExportFunction proxyOnDeleteFn;
    ExportFunction proxyOnVmStartFn;
    ExportFunction proxyOnConfigureFn;
    ExportFunction proxyOnTickFn;
    ExportFunction proxyOnNewConnectionFn;
    ExportFunction proxyOnDownstreamDataFn;
    ExportFunction proxyOnDownstreamConnectionCloseFn;
    ExportFunction proxyOnUpstreamDataFn;
    ExportFunction proxyOnUpstreamConnectionCloseFn;
    ExportFunction proxyOnRequestHeadersFn;
    ExportFunction proxyOnRequestBodyFn;
    ExportFunction proxyOnRequestTrailersFn;
    ExportFunction proxyOnResponseHeadersFn;
    ExportFunction proxyOnResponseBodyFn;
    ExportFunction proxyOnResponseTrailersFn;
    ExportFunction proxyOnHttpCallResponseFn;
    ExportFunction proxyOnGrpcReceiveInitialMetadataFn;
    ExportFunction proxyOnGrpcReceiveFn;
    ExportFunction proxyOnGrpcReceiveTrailingMetadataFn;
    ExportFunction proxyOnGrpcCloseFn;
    ExportFunction proxyOnQueueReadyFn;
    ExportFunction proxyOnForeignFunctionFn;
    static final int U32_LEN = 4;

    ABI() {
    }

    Handler getHandler() {
        return this.handler;
    }

    void setHandler(Handler handler) {
        this.handler = handler;
    }

    void setInstance(Instance instance) {
        this.memory = instance.memory();
        Instance.Exports exports = instance.exports();
        this.mallocFn = this.lookupFunction(exports, "proxy_on_memory_allocate");
        if (this.mallocFn == null) {
            this.mallocFn = this.lookupFunction(exports, "malloc");
        }
        if (this.mallocFn == null) {
            throw new WasmRuntimeException("malloc function not found");
        }
        this.initializeFn = this.lookupFunction(exports, "_initialize");
        this.mainFn = this.lookupFunction(exports, "main");
        this.startFn = this.lookupFunction(exports, "_start");
        this.proxyOnContextCreateFn = this.lookupFunction(exports, "proxy_on_context_create");
        this.proxyOnDoneFn = this.lookupFunction(exports, "proxy_on_done");
        this.proxyOnLogFn = this.lookupFunction(exports, "proxy_on_log");
        this.proxyOnDeleteFn = this.lookupFunction(exports, "proxy_on_delete");
        this.proxyOnVmStartFn = this.lookupFunction(exports, "proxy_on_vm_start");
        this.proxyOnConfigureFn = this.lookupFunction(exports, "proxy_on_configure");
        this.proxyOnTickFn = this.lookupFunction(exports, "proxy_on_tick");
        this.proxyOnNewConnectionFn = this.lookupFunction(exports, "proxy_on_new_connection");
        this.proxyOnDownstreamDataFn = this.lookupFunction(exports, "proxy_on_downstream_data");
        this.proxyOnDownstreamConnectionCloseFn = this.lookupFunction(exports, "proxy_on_downstream_connection_close");
        this.proxyOnUpstreamDataFn = this.lookupFunction(exports, "proxy_on_upstream_data");
        this.proxyOnUpstreamConnectionCloseFn = this.lookupFunction(exports, "proxy_on_upstream_connection_close");
        this.proxyOnRequestHeadersFn = this.lookupFunction(exports, "proxy_on_request_headers");
        this.proxyOnRequestBodyFn = this.lookupFunction(exports, "proxy_on_request_body");
        this.proxyOnRequestTrailersFn = this.lookupFunction(exports, "proxy_on_request_trailers");
        this.proxyOnResponseHeadersFn = this.lookupFunction(exports, "proxy_on_response_headers");
        this.proxyOnResponseBodyFn = this.lookupFunction(exports, "proxy_on_response_body");
        this.proxyOnResponseTrailersFn = this.lookupFunction(exports, "proxy_on_response_trailers");
        this.proxyOnHttpCallResponseFn = this.lookupFunction(exports, "proxy_on_http_call_response");
        this.proxyOnGrpcReceiveInitialMetadataFn = this.lookupFunction(exports, "proxy_on_grpc_receive_initial_metadata");
        this.proxyOnGrpcReceiveFn = this.lookupFunction(exports, "proxy_on_grpc_receive");
        this.proxyOnGrpcReceiveTrailingMetadataFn = this.lookupFunction(exports, "proxy_on_grpc_receive_trailing_metadata");
        this.proxyOnGrpcCloseFn = this.lookupFunction(exports, "proxy_on_grpc_close");
        this.proxyOnQueueReadyFn = this.lookupFunction(exports, "proxy_on_queue_ready");
        this.proxyOnForeignFunctionFn = this.lookupFunction(exports, "proxy_on_foreign_function");
    }

    private ExportFunction lookupFunction(Instance.Exports exports, String name) {
        try {
            return exports.function(name);
        }
        catch (InvalidException e) {
            return null;
        }
    }

    private void putUint32(int address, int value) throws WasmException {
        try {
            this.memory.writeI32(address, value);
        }
        catch (RuntimeException e) {
            throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
        }
    }

    private long getUint32(int address) throws WasmException {
        try {
            return this.memory.readU32(address);
        }
        catch (RuntimeException e) {
            throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
        }
    }

    private void putByte(int address, byte value) throws WasmException {
        try {
            this.memory.writeByte(address, value);
        }
        catch (RuntimeException e) {
            throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
        }
    }

    private void putMemory(int address, byte[] data) throws WasmException {
        try {
            this.memory.write(address, data);
        }
        catch (RuntimeException e) {
            throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
        }
    }

    private void putMemory(int address, ByteBuffer data) throws WasmException {
        try {
            if (data.hasArray()) {
                byte[] array = data.array();
                this.memory.write(address, array, data.position(), data.remaining());
            } else {
                byte[] bytes = new byte[data.remaining()];
                data.get(bytes);
                this.memory.write(address, bytes);
            }
        }
        catch (RuntimeException e) {
            throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
        }
    }

    private byte[] readMemory(int address, int len) throws WasmException {
        try {
            return this.memory.readBytes(address, len);
        }
        catch (RuntimeException e) {
            throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
        }
    }

    private void copyIntoInstance(byte[] value, int retPtr, int retSize) throws WasmException {
        try {
            if (value.length != 0) {
                int addr = this.malloc(value.length);
                this.putMemory(addr, value);
                this.putUint32(retPtr, addr);
            } else {
                this.putUint32(retPtr, 0);
            }
            this.putUint32(retSize, value.length);
        }
        catch (WasmException e) {
            throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
        }
    }

    boolean initialize() {
        if (this.initializeFn == null) {
            return false;
        }
        this.initializeFn.apply(new long[0]);
        return true;
    }

    boolean main(int arg0, int arg1) {
        if (this.mainFn == null) {
            return false;
        }
        this.mainFn.apply(new long[]{arg0, arg1});
        return true;
    }

    boolean start() {
        if (this.startFn == null) {
            return false;
        }
        this.startFn.apply(new long[0]);
        return true;
    }

    int malloc(int size) throws WasmException {
        assert (size > 0) : "malloc size must be greater than zero";
        long ptr = this.mallocFn.apply(new long[]{size})[0];
        if (ptr == 0L) {
            throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
        }
        return (int)ptr;
    }

    void proxyOnContextCreate(int contextID, int parentContextID) {
        if (this.proxyOnContextCreateFn == null) {
            return;
        }
        this.proxyOnContextCreateFn.apply(new long[]{contextID, parentContextID});
    }

    boolean proxyOnDone(int context_id) {
        if (this.proxyOnDoneFn == null) {
            return true;
        }
        long result = this.proxyOnDoneFn.apply(new long[]{context_id})[0];
        return result != 0L;
    }

    void proxyOnLog(int context_id) {
        if (this.proxyOnLogFn == null) {
            return;
        }
        this.proxyOnLogFn.apply(new long[]{context_id});
    }

    void proxyOnDelete(int context_id) {
        if (this.proxyOnDeleteFn == null) {
            return;
        }
        this.proxyOnDeleteFn.apply(new long[]{context_id});
    }

    @WasmExport
    int proxyDone() {
        return this.handler.done().getValue();
    }

    @WasmExport
    int proxySetEffectiveContext(int contextId) {
        return this.handler.setEffectiveContextID(contextId).getValue();
    }

    boolean proxyOnVmStart(int arg0, int arg1) {
        if (this.proxyOnVmStartFn == null) {
            return true;
        }
        long result = this.proxyOnVmStartFn.apply(new long[]{arg0, arg1})[0];
        return result != 0L;
    }

    boolean proxyOnConfigure(int arg0, int arg1) {
        if (this.proxyOnConfigureFn == null) {
            return true;
        }
        long result = this.proxyOnConfigureFn.apply(new long[]{arg0, arg1})[0];
        return result != 0L;
    }

    @WasmExport
    int proxyLog(int logLevel, int messageData, int messageSize) {
        try {
            byte[] msg = this.memory.readBytes(messageData, messageSize);
            this.handler.log(LogLevel.fromInt(logLevel), Helpers.string(msg));
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyGetLogLevel(int returnLogLevel) {
        try {
            LogLevel level = this.handler.getLogLevel();
            this.putUint32(returnLogLevel, level.value());
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyGetCurrentTimeNanoseconds(int returnTime) {
        try {
            int currentTimeNanoseconds = this.handler.getCurrentTimeNanoseconds();
            this.putUint32(returnTime, currentTimeNanoseconds);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxySetTickPeriodMilliseconds(int tick_period) {
        return this.handler.setTickPeriodMilliseconds(tick_period).getValue();
    }

    void proxyOnTick(int arg0) {
        if (this.proxyOnTickFn == null) {
            return;
        }
        this.proxyOnTickFn.apply(new long[]{arg0});
    }

    @WasmExport
    int proxyGetBufferBytes(int bufferType, int start, int chunkLength, int returnBufferData, int returnBufferSize) {
        try {
            ByteBuffer buffer;
            byte[] b = this.getBuffer(bufferType);
            if (b == null || b.length == 0) {
                return WasmResult.NOT_FOUND.getValue();
            }
            if (start < 0) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            int maxChunkLength = b.length - start;
            if (chunkLength < 0 || chunkLength > maxChunkLength) {
                chunkLength = maxChunkLength;
            }
            if (start + chunkLength > (buffer = ByteBuffer.wrap(b)).capacity()) {
                chunkLength = buffer.capacity() - start;
            }
            try {
                buffer.position(start);
                buffer.limit(start + chunkLength);
            }
            catch (IllegalArgumentException e) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            int addr = this.malloc(chunkLength);
            this.putMemory(addr, buffer);
            this.putUint32(returnBufferData, addr);
            this.putUint32(returnBufferSize, chunkLength);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxySetBufferBytes(int bufferType, int start, int length, int dataPtr, int dataSize) {
        try {
            byte[] buf = this.getBuffer(bufferType);
            if (buf == null) {
                return WasmResult.NOT_FOUND.getValue();
            }
            byte[] content = this.memory.readBytes(dataPtr, dataSize);
            content = Helpers.replaceBytes(buf, content, start, length);
            WasmResult result = this.setBuffer(bufferType, content);
            return result.getValue();
        }
        catch (WasmRuntimeException e) {
            return WasmResult.INVALID_MEMORY_ACCESS.getValue();
        }
    }

    @WasmExport
    int proxyGetBufferStatus(int bufferType, int returnBufferSize, int returnUnused) {
        try {
            byte[] b = this.getBuffer(bufferType);
            if (b == null) {
                return WasmResult.NOT_FOUND.getValue();
            }
            this.putUint32(returnBufferSize, b.length);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    private byte[] getBuffer(int bufferType) {
        BufferType knownType = BufferType.fromInt(bufferType);
        if (knownType == null) {
            return this.handler.getCustomBuffer(bufferType);
        }
        switch (knownType) {
            case HTTP_REQUEST_BODY: {
                return this.handler.getHttpRequestBody();
            }
            case HTTP_RESPONSE_BODY: {
                return this.handler.getHttpResponseBody();
            }
            case DOWNSTREAM_DATA: {
                return this.handler.getDownStreamData();
            }
            case UPSTREAM_DATA: {
                return this.handler.getUpstreamData();
            }
            case HTTP_CALL_RESPONSE_BODY: {
                return this.handler.getHttpCallResponseBody();
            }
            case GRPC_RECEIVE_BUFFER: {
                return this.handler.getGrpcReceiveBuffer();
            }
            case PLUGIN_CONFIGURATION: {
                return this.handler.getPluginConfig();
            }
            case VM_CONFIGURATION: {
                return this.handler.getVmConfig();
            }
            case CALL_DATA: {
                return this.handler.getFuncCallData();
            }
        }
        return null;
    }

    private WasmResult setBuffer(int bufferType, byte[] buffer) {
        BufferType knownType = BufferType.fromInt(bufferType);
        if (knownType == null) {
            return this.handler.setCustomBuffer(bufferType, buffer);
        }
        switch (knownType) {
            case HTTP_REQUEST_BODY: {
                return this.handler.setHttpRequestBody(buffer);
            }
            case HTTP_RESPONSE_BODY: {
                return this.handler.setHttpResponseBody(buffer);
            }
            case DOWNSTREAM_DATA: {
                return this.handler.setDownStreamData(buffer);
            }
            case UPSTREAM_DATA: {
                return this.handler.setUpstreamData(buffer);
            }
            case HTTP_CALL_RESPONSE_BODY: {
                return this.handler.setHttpCallResponseBody(buffer);
            }
            case GRPC_RECEIVE_BUFFER: {
                return this.handler.setGrpcReceiveBuffer(buffer);
            }
            case CALL_DATA: {
                return this.handler.setFuncCallData(buffer);
            }
        }
        return WasmResult.NOT_FOUND;
    }

    @WasmExport
    int proxyGetHeaderMapSize(int mapType, int returnSize) {
        try {
            ProxyMap header = this.getMap(mapType);
            if (header == null) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            ArrayProxyMap cloneMap = new ArrayProxyMap(header);
            int totalBytesLen = 4;
            for (Map.Entry<String, String> entry : cloneMap.entries()) {
                String key = entry.getKey();
                String value = entry.getValue();
                totalBytesLen += 8;
                totalBytesLen += key.length() + 1 + value.length() + 1;
            }
            this.putUint32(returnSize, totalBytesLen);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyGetHeaderMapPairs(int mapType, int returnDataPtr, int returnDataSize) {
        try {
            ProxyMap header = this.getMap(mapType);
            if (header == null) {
                return WasmResult.NOT_FOUND.getValue();
            }
            ArrayList cloneMap = new ArrayList();
            int totalBytesLen = 4;
            int addr = this.malloc(totalBytesLen += header.streamBytes().mapToInt(entry -> {
                byte[] key = (byte[])entry.getKey();
                byte[] value = (byte[])entry.getValue();
                cloneMap.add(Map.entry(key, value));
                return 8 + key.length + 1 + value.length + 1;
            }).sum());
            this.putUint32(addr, cloneMap.size());
            int lenPtr = addr + 4;
            int dataPtr = lenPtr + 8 * cloneMap.size();
            for (Map.Entry entry2 : cloneMap) {
                byte[] key = (byte[])entry2.getKey();
                byte[] value = (byte[])entry2.getValue();
                this.putUint32(lenPtr, key.length);
                this.putUint32(lenPtr += 4, value.length);
                lenPtr += 4;
                this.putMemory(dataPtr, key);
                this.putByte(dataPtr += key.length, (byte)0);
                this.putMemory(++dataPtr, value);
                this.putByte(dataPtr += value.length, (byte)0);
                ++dataPtr;
            }
            this.putUint32(returnDataPtr, addr);
            this.putUint32(returnDataSize, totalBytesLen);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxySetHeaderMapPairs(int mapType, int ptr, int size) {
        try {
            ProxyMap headerMap = this.getMap(mapType);
            if (headerMap == null) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            ProxyMap newMap = this.decodeMap(ptr, size);
            for (Map.Entry<String, String> entry : newMap.entries()) {
                headerMap.put(entry.getKey(), entry.getValue());
            }
            return WasmResult.OK.getValue();
        }
        catch (WasmRuntimeException e) {
            return WasmResult.INVALID_MEMORY_ACCESS.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyGetHeaderMapValue(int mapType, int keyDataPtr, int keySize, int valueDataPtr, int valueSize) {
        try {
            ProxyMap headerMap = this.getMap(mapType);
            if (headerMap == null) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            String key = Helpers.string(this.readMemory(keyDataPtr, keySize));
            String value = headerMap.get(key);
            if (value == null) {
                return WasmResult.NOT_FOUND.getValue();
            }
            this.copyIntoInstance(Helpers.bytes(value), valueDataPtr, valueSize);
            return WasmResult.OK.getValue();
        }
        catch (WasmRuntimeException e) {
            return WasmResult.INVALID_MEMORY_ACCESS.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyAddHeaderMapValue(int mapType, int keyDataPtr, int keySize, int valueDataPtr, int valueSize) {
        try {
            ProxyMap headerMap = this.getMap(mapType);
            if (headerMap == null) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            String key = Helpers.string(this.readMemory(keyDataPtr, keySize));
            String value = Helpers.string(this.readMemory(valueDataPtr, valueSize));
            headerMap.add(key, value);
            return WasmResult.OK.getValue();
        }
        catch (WasmRuntimeException e) {
            return WasmResult.INVALID_MEMORY_ACCESS.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyReplaceHeaderMapValue(int mapType, int keyDataPtr, int keySize, int valueDataPtr, int valueSize) {
        try {
            ProxyMap headerMap = this.getMap(mapType);
            if (headerMap == null) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            String key = Helpers.string(this.readMemory(keyDataPtr, keySize));
            String value = Helpers.string(this.readMemory(valueDataPtr, valueSize));
            headerMap.put(key, value);
            return WasmResult.OK.getValue();
        }
        catch (WasmRuntimeException e) {
            return WasmResult.INVALID_MEMORY_ACCESS.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyRemoveHeaderMapValue(int mapType, int keyDataPtr, int keySize) {
        try {
            ProxyMap headerMap = this.getMap(mapType);
            if (headerMap == null) {
                return WasmResult.NOT_FOUND.getValue();
            }
            String key = Helpers.string(this.readMemory(keyDataPtr, keySize));
            if (key.isEmpty()) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            headerMap.remove(key);
            return WasmResult.OK.getValue();
        }
        catch (WasmRuntimeException e) {
            return WasmResult.INVALID_MEMORY_ACCESS.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    private ProxyMap getMap(int mapType) {
        MapType knownType = MapType.fromInt(mapType);
        if (knownType == null) {
            return this.handler.getCustomHeaders(mapType);
        }
        switch (knownType) {
            case HTTP_REQUEST_HEADERS: {
                return this.handler.getHttpRequestHeaders();
            }
            case HTTP_REQUEST_TRAILERS: {
                return this.handler.getHttpRequestTrailers();
            }
            case HTTP_RESPONSE_HEADERS: {
                return this.handler.getHttpResponseHeaders();
            }
            case HTTP_RESPONSE_TRAILERS: {
                return this.handler.getHttpResponseTrailers();
            }
            case HTTP_CALL_RESPONSE_HEADERS: {
                return this.handler.getHttpCallResponseHeaders();
            }
            case HTTP_CALL_RESPONSE_TRAILERS: {
                return this.handler.getHttpCallResponseTrailers();
            }
            case GRPC_RECEIVE_INITIAL_METADATA: {
                return this.handler.getGrpcReceiveInitialMetaData();
            }
            case GRPC_RECEIVE_TRAILING_METADATA: {
                return this.handler.getGrpcReceiveTrailerMetaData();
            }
        }
        return null;
    }

    private ProxyMap decodeMap(int addr, int mem_size) throws WasmException {
        if (mem_size < 4) {
            return new ArrayProxyMap();
        }
        long mapSize = this.getUint32(addr);
        long dataOffset = 4L + 8L * mapSize;
        if (dataOffset >= (long)mem_size) {
            return new ArrayProxyMap();
        }
        ArrayProxyMap result = new ArrayProxyMap((int)mapSize);
        int i = 0;
        while ((long)i < mapSize) {
            int keySizeOffset = 4 + 8 * i;
            int valueSizeOffset = keySizeOffset + 4;
            long keySize = this.getUint32(addr + keySizeOffset);
            long valueSize = this.getUint32(addr + valueSizeOffset);
            if (dataOffset >= (long)mem_size || dataOffset + keySize + valueSize + 2L > (long)mem_size) break;
            String key = Helpers.string(this.readMemory((int)((long)addr + dataOffset), (int)keySize));
            String value = Helpers.string(this.readMemory((int)((long)addr + (dataOffset += keySize + 1L)), (int)valueSize));
            dataOffset += valueSize + 1L;
            result.add(key, value);
            ++i;
        }
        return result;
    }

    @WasmExport
    int proxyContinueStream(int arg) {
        StreamType streamType = StreamType.fromInt(arg);
        if (streamType == null) {
            return WasmResult.BAD_ARGUMENT.getValue();
        }
        WasmResult result = this.handler.setAction(streamType, Action.CONTINUE);
        return result.getValue();
    }

    @WasmExport
    int proxyCloseStream(int proxyStreamType) {
        return WasmResult.UNIMPLEMENTED.getValue();
    }

    @WasmExport
    int proxyGetStatus(int returnStatusCode, int returnStatusMessageData, int returnStatusMessageSize) {
        return WasmResult.UNIMPLEMENTED.getValue();
    }

    int proxyOnNewConnection(int arg0) {
        if (this.proxyOnNewConnectionFn == null) {
            return Action.CONTINUE.getValue();
        }
        long result = this.proxyOnNewConnectionFn.apply(new long[]{arg0})[0];
        return (int)result;
    }

    int proxyOnDownstreamData(int contextId, int dataSize, int endOfStream) {
        if (this.proxyOnDownstreamDataFn == null) {
            return Action.CONTINUE.getValue();
        }
        long result = this.proxyOnDownstreamDataFn.apply(new long[]{contextId, dataSize, endOfStream})[0];
        return (int)result;
    }

    void proxyOnDownstreamConnectionClose(int arg0, int arg1) {
        if (this.proxyOnDownstreamConnectionCloseFn == null) {
            return;
        }
        this.proxyOnDownstreamConnectionCloseFn.apply(new long[]{arg0, arg1});
    }

    int proxyOnUpstreamData(int arg0, int arg1, int arg2) {
        if (this.proxyOnUpstreamDataFn == null) {
            return Action.CONTINUE.getValue();
        }
        long result = this.proxyOnUpstreamDataFn.apply(new long[]{arg0, arg1, arg2})[0];
        return (int)result;
    }

    void proxyOnUpstreamConnectionClose(int arg0, int arg1) {
        if (this.proxyOnUpstreamConnectionCloseFn == null) {
            return;
        }
        this.proxyOnUpstreamConnectionCloseFn.apply(new long[]{arg0, arg1});
    }

    int proxyOnRequestHeaders(int contextID, int headers, int endOfStream) {
        if (this.proxyOnRequestHeadersFn == null) {
            return Action.CONTINUE.getValue();
        }
        long result = this.proxyOnRequestHeadersFn.apply(new long[]{contextID, headers, endOfStream})[0];
        return (int)result;
    }

    int proxyOnRequestBody(int contextId, int bodySize, int arg2) {
        if (this.proxyOnRequestBodyFn == null) {
            return Action.CONTINUE.getValue();
        }
        long result = this.proxyOnRequestBodyFn.apply(new long[]{contextId, bodySize, arg2})[0];
        return (int)result;
    }

    int proxyOnRequestTrailers(int arg0, int arg1) {
        if (this.proxyOnRequestTrailersFn == null) {
            return Action.CONTINUE.getValue();
        }
        long result = this.proxyOnRequestTrailersFn.apply(new long[]{arg0, arg1})[0];
        return (int)result;
    }

    int proxyOnResponseHeaders(int arg0, int arg1, int arg2) {
        if (this.proxyOnResponseHeadersFn == null) {
            return Action.CONTINUE.getValue();
        }
        long result = this.proxyOnResponseHeadersFn.apply(new long[]{arg0, arg1, arg2})[0];
        return (int)result;
    }

    int proxyOnResponseBody(int arg0, int arg1, int arg2) {
        if (this.proxyOnResponseBodyFn == null) {
            return Action.CONTINUE.getValue();
        }
        long result = this.proxyOnResponseBodyFn.apply(new long[]{arg0, arg1, arg2})[0];
        return (int)result;
    }

    int proxyOnResponseTrailers(int arg0, int arg1) {
        if (this.proxyOnResponseTrailersFn == null) {
            return Action.CONTINUE.getValue();
        }
        long result = this.proxyOnResponseTrailersFn.apply(new long[]{arg0, arg1})[0];
        return (int)result;
    }

    @WasmExport
    int proxySendLocalResponse(int responseCode, int responseCodeDetailsData, int responseCodeDetailsSize, int responseBodyData, int responseBodySize, int additionalHeadersMapData, int additionalHeadersSize, int grpcStatus) {
        try {
            byte[] responseCodeDetails = null;
            if (responseCodeDetailsSize > 0) {
                responseCodeDetails = this.memory.readBytes(responseCodeDetailsData, responseCodeDetailsSize);
            }
            byte[] responseBody = new byte[]{};
            if (responseBodySize > 0) {
                responseBody = this.memory.readBytes(responseBodyData, responseBodySize);
            }
            ProxyMap additionalHeaders = this.decodeMap(additionalHeadersMapData, additionalHeadersSize);
            WasmResult result = this.handler.sendHttpResponse(responseCode, responseCodeDetails, responseBody, additionalHeaders, grpcStatus);
            return result.getValue();
        }
        catch (WasmRuntimeException e) {
            return WasmResult.INVALID_MEMORY_ACCESS.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    @Deprecated(since="0.2.0")
    void proxyContinueRequest() {
        this.handler.setAction(StreamType.REQUEST, Action.CONTINUE);
    }

    @WasmExport
    @Deprecated(since="0.2.0")
    void proxyContinueResponse() {
        this.handler.setAction(StreamType.RESPONSE, Action.CONTINUE);
    }

    @WasmExport
    @Deprecated(since="0.2.0")
    void proxyClearRouteCache() {
        this.handler.clearRouteCache();
    }

    @WasmExport
    int proxyHttpCall(int uriData, int uriSize, int headersData, int headersSize, int bodyData, int bodySize, int trailersData, int trailersSize, int timeout, int returnCalloutID) {
        try {
            String uri = Helpers.string(this.readMemory(uriData, uriSize));
            ProxyMap headers = this.decodeMap(headersData, headersSize);
            byte[] body = this.readMemory(bodyData, bodySize);
            ProxyMap trailers = this.decodeMap(trailersData, trailersSize);
            int calloutId = this.handler.httpCall(uri, headers, body, trailers, timeout);
            this.putUint32(returnCalloutID, calloutId);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyDispatchHttpCall(int upstreamNameData, int upstreamNameSize, int headersData, int headersSize, int bodyData, int bodySize, int trailersData, int trailersSize, int timeoutMilliseconds, int returnCalloutID) {
        try {
            String upstreamName = Helpers.string(this.readMemory(upstreamNameData, upstreamNameSize));
            ProxyMap headers = this.decodeMap(headersData, headersSize);
            byte[] body = this.readMemory(bodyData, bodySize);
            ProxyMap trailers = this.decodeMap(trailersData, trailersSize);
            int calloutId = this.handler.dispatchHttpCall(upstreamName, headers, body, trailers, timeoutMilliseconds);
            this.putUint32(returnCalloutID, calloutId);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    void proxyOnHttpCallResponse(int arg0, int arg1, int arg2, int arg3, int arg4) {
        if (this.proxyOnHttpCallResponseFn == null) {
            return;
        }
        this.proxyOnHttpCallResponseFn.apply(new long[]{arg0, arg1, arg2, arg3, arg4});
    }

    @WasmExport
    int proxyGrpcCall(int upstreamNameData, int upstreamNameSize, int serviceNameData, int serviceNameSize, int methodNameData, int methodNameSize, int serialized_initial_metadataData, int serialized_initial_metadataSize, int messageData, int messageSize, int timeout, int returnCalloutID) {
        try {
            String upstreamName = Helpers.string(this.readMemory(upstreamNameData, upstreamNameSize));
            String serviceName = Helpers.string(this.readMemory(serviceNameData, serviceNameSize));
            String methodName = Helpers.string(this.readMemory(methodNameData, methodNameSize));
            ProxyMap initialMetadata = this.decodeMap(serialized_initial_metadataData, serialized_initial_metadataSize);
            byte[] message = this.readMemory(messageData, messageSize);
            int callId = this.handler.grpcCall(upstreamName, serviceName, methodName, initialMetadata, message, timeout);
            this.putUint32(returnCalloutID, callId);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyGrpcStream(int upstreamNameData, int upstreamNameSize, int serviceNameData, int serviceNameSize, int methodNameData, int methodNameSize, int serialized_initial_metadataData, int serialized_initial_metadataSize, int returnStreamId) {
        try {
            String upstreamName = Helpers.string(this.readMemory(upstreamNameData, upstreamNameSize));
            String serviceName = Helpers.string(this.readMemory(serviceNameData, serviceNameSize));
            String methodName = Helpers.string(this.readMemory(methodNameData, methodNameSize));
            ProxyMap initialMetadata = this.decodeMap(serialized_initial_metadataData, serialized_initial_metadataSize);
            int streamId = this.handler.grpcStream(upstreamName, serviceName, methodName, initialMetadata);
            this.putUint32(returnStreamId, streamId);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyGrpcSend(int streamId, int messageData, int messageSize, int endStream) {
        try {
            byte[] message = this.readMemory(messageData, messageSize);
            WasmResult result = this.handler.grpcSend(streamId, message, endStream);
            return result.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyGrpcCancel(int callOrstreamId) {
        WasmResult result = this.handler.grpcCancel(callOrstreamId);
        return result.getValue();
    }

    @WasmExport
    int proxyGrpcClose(int callOrstreamId) {
        WasmResult result = this.handler.grpcClose(callOrstreamId);
        return result.getValue();
    }

    void proxyOnGrpcReceiveInitialMetadata(int contextId, int callId, int numElements) {
        if (this.proxyOnGrpcReceiveInitialMetadataFn == null) {
            return;
        }
        this.proxyOnGrpcReceiveInitialMetadataFn.apply(new long[]{contextId, callId, numElements});
    }

    void proxyOnGrpcReceive(int contextId, int callId, int messageSize) {
        if (this.proxyOnGrpcReceiveFn == null) {
            return;
        }
        this.proxyOnGrpcReceiveFn.apply(new long[]{contextId, callId, messageSize});
    }

    void proxyOnGrpcReceiveTrailingMetadata(int contextId, int callId, int numElements) {
        if (this.proxyOnGrpcReceiveTrailingMetadataFn == null) {
            return;
        }
        this.proxyOnGrpcReceiveTrailingMetadataFn.apply(new long[]{contextId, callId, numElements});
    }

    void proxyOnGrpcClose(int contextId, int callId, int statusCode) {
        if (this.proxyOnGrpcCloseFn == null) {
            return;
        }
        this.proxyOnGrpcCloseFn.apply(new long[]{contextId, callId, statusCode});
    }

    @WasmExport
    int proxySetSharedData(int keyDataPtr, int keySize, int valueDataPtr, int valueSize, int cas) {
        try {
            String key = Helpers.string(this.readMemory(keyDataPtr, keySize));
            byte[] value = this.readMemory(valueDataPtr, valueSize);
            WasmResult result = this.handler.setSharedData(key, value, cas);
            return result.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyGetSharedData(int keyDataPtr, int keySize, int returnValueData, int returnValueSize, int returnCas) {
        try {
            String key = Helpers.string(this.readMemory(keyDataPtr, keySize));
            SharedData value = this.handler.getSharedData(key);
            if (value == null) {
                return WasmResult.NOT_FOUND.getValue();
            }
            try {
                if (value.data().length != 0) {
                    int addr = this.malloc(value.data().length);
                    this.putMemory(addr, value.data());
                    this.putUint32(returnValueData, addr);
                } else {
                    this.putUint32(returnValueData, 0);
                }
                this.putUint32(returnValueSize, value.data().length);
            }
            catch (WasmException e) {
                throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
            }
            this.putUint32(returnCas, value.cas());
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyRegisterSharedQueue(int queueNameDataPtr, int queueNameSize, int returnQueueId) {
        try {
            String queueName = Helpers.string(this.readMemory(queueNameDataPtr, queueNameSize));
            byte[] vmId = this.handler.getProperty(List.of("vm_id"));
            if (vmId == null) {
                return WasmResult.INTERNAL_FAILURE.getValue();
            }
            int queueId = this.handler.registerSharedQueue(new QueueName(Helpers.string(vmId), queueName));
            this.putUint32(returnQueueId, queueId);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyResolveSharedQueue(int vmIdDataPtr, int vmIdSize, int queueNameDataPtr, int queueNameSize, int returnQueueId) {
        try {
            String vmId = Helpers.string(this.readMemory(vmIdDataPtr, vmIdSize));
            String queueName = Helpers.string(this.readMemory(queueNameDataPtr, queueNameSize));
            int queueId = this.handler.resolveSharedQueue(new QueueName(vmId, queueName));
            this.putUint32(returnQueueId, queueId);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyEnqueueSharedQueue(int queueId, int valueDataPtr, int valueSize) {
        try {
            byte[] value = this.readMemory(valueDataPtr, valueSize);
            WasmResult result = this.handler.enqueueSharedQueue(queueId, value);
            return result.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyDequeueSharedQueue(int queueId, int returnValueData, int returnValueSize) {
        try {
            byte[] value = this.handler.dequeueSharedQueue(queueId);
            if (value == null) {
                return WasmResult.EMPTY.getValue();
            }
            try {
                if (value.length != 0) {
                    int addr = this.malloc(value.length);
                    this.putMemory(addr, value);
                    this.putUint32(returnValueData, addr);
                } else {
                    this.putUint32(returnValueData, 0);
                }
                this.putUint32(returnValueSize, value.length);
            }
            catch (WasmException e) {
                throw new WasmException(WasmResult.INVALID_MEMORY_ACCESS);
            }
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    void proxyOnQueueReady(int arg0, int arg1) {
        if (this.proxyOnQueueReadyFn == null) {
            return;
        }
        this.proxyOnQueueReadyFn.apply(new long[]{arg0, arg1});
    }

    @WasmExport
    int proxyDefineMetric(int metricType, int nameDataPtr, int nameSize, int returnMetricId) {
        try {
            MetricType type = MetricType.fromInt(metricType);
            if (type == null) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            String name = Helpers.string(this.readMemory(nameDataPtr, nameSize));
            int metricId = this.handler.defineMetric(type, name);
            this.putUint32(returnMetricId, metricId);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyRecordMetric(int metricId, long value) {
        WasmResult result = this.handler.recordMetric(metricId, value);
        return result.getValue();
    }

    @WasmExport
    int proxyIncrementMetric(int metricId, long value) {
        WasmResult result = this.handler.incrementMetric(metricId, value);
        return result.getValue();
    }

    @WasmExport
    int proxyGetMetric(int metricId, int returnValuePtr) {
        try {
            long result = this.handler.getMetric(metricId);
            this.putUint32(returnValuePtr, (int)result);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyRemoveMetric(int metricId) {
        WasmResult result = this.handler.removeMetric(metricId);
        return result.getValue();
    }

    @WasmExport
    int proxyGetProperty(int keyPtr, int keySize, int returnValueData, int returnValueSize) {
        try {
            byte[] keyBytes = this.readMemory(keyPtr, keySize);
            if (keyBytes.length == 0) {
                return WasmResult.BAD_ARGUMENT.getValue();
            }
            List<String> path = Helpers.split(Helpers.string(keyBytes), '\u0000');
            byte[] value = this.handler.getProperty(path);
            if (value == null) {
                return WasmResult.NOT_FOUND.getValue();
            }
            this.copyIntoInstance(value, returnValueData, returnValueSize);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxySetProperty(int pathDataPtr, int pathSize, int valueDataPtr, int valueSize) {
        try {
            List<String> path = Helpers.split(Helpers.string(this.readMemory(pathDataPtr, pathSize)), '\u0000');
            byte[] value = this.readMemory(valueDataPtr, valueSize);
            WasmResult result = this.handler.setProperty(path, value);
            return result.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    @WasmExport
    int proxyCallForeignFunction(int nameDataPtr, int nameSize, int argumentDataPtr, int argumentSize, int returnResultsPtr, int returnResultsSizePtr) {
        try {
            String name = Helpers.string(this.readMemory(nameDataPtr, nameSize));
            byte[] argument = this.readMemory(argumentDataPtr, argumentSize);
            ForeignFunction func = this.handler.getForeignFunction(name);
            if (func == null) {
                return WasmResult.NOT_FOUND.getValue();
            }
            byte[] result = (byte[])func.apply(argument);
            int addr = this.malloc(result.length);
            this.putMemory(addr, result);
            this.putUint32(returnResultsPtr, addr);
            this.putUint32(returnResultsSizePtr, result.length);
            return WasmResult.OK.getValue();
        }
        catch (WasmException e) {
            return e.result().getValue();
        }
    }

    void proxyOnForeignFunction(int contextId, int functionId, int argumentsSize) {
        if (this.proxyOnForeignFunctionFn == null) {
            return;
        }
        this.proxyOnForeignFunctionFn.apply(new long[]{contextId, functionId, argumentsSize});
    }
}

