/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.internal.Action;
import io.roastedroot.proxywasm.internal.Context;
import io.roastedroot.proxywasm.internal.Handler;
import io.roastedroot.proxywasm.internal.Helpers;
import io.roastedroot.proxywasm.internal.ProxyMap;
import io.roastedroot.proxywasm.internal.ProxyWasm;
import io.roastedroot.proxywasm.internal.StreamType;

public class HttpContext
extends Context {
    private final Handler handler;

    HttpContext(ProxyWasm proxyWasm, Handler handler) {
        super(proxyWasm);
        this.handler = handler;
    }

    @Override
    Handler handler() {
        return this.handler;
    }

    public boolean hasOnRequestHeaders() {
        return this.proxyWasm.abi().proxyOnRequestHeadersFn != null;
    }

    public Action callOnRequestHeaders(boolean endOfStream) {
        ProxyMap headers = this.handler.getHttpRequestHeaders();
        int result = this.proxyWasm.abi().proxyOnRequestHeaders(this.id, Helpers.len(headers), endOfStream ? 1 : 0);
        Action action = Action.fromInt(result);
        this.handler.setAction(StreamType.REQUEST, action);
        return action;
    }

    public boolean hasOnResponseHeaders() {
        return this.proxyWasm.abi().proxyOnResponseHeadersFn != null;
    }

    public Action callOnResponseHeaders(boolean endOfStream) {
        ProxyMap headers = this.handler.getHttpResponseHeaders();
        int result = this.proxyWasm.abi().proxyOnResponseHeaders(this.id, Helpers.len(headers), endOfStream ? 1 : 0);
        Action action = Action.fromInt(result);
        this.handler.setAction(StreamType.RESPONSE, action);
        return action;
    }

    public boolean hasOnRequestBody() {
        return this.proxyWasm.abi().proxyOnRequestBodyFn != null;
    }

    public Action callOnRequestBody(boolean endOfStream) {
        byte[] requestBody = this.handler.getHttpRequestBody();
        int result = this.proxyWasm.abi().proxyOnRequestBody(this.id, Helpers.len(requestBody), endOfStream ? 1 : 0);
        Action action = Action.fromInt(result);
        this.handler.setAction(StreamType.REQUEST, action);
        return action;
    }

    public boolean hasOnResponseBody() {
        return this.proxyWasm.abi().proxyOnResponseBodyFn != null;
    }

    public Action callOnResponseBody(boolean endOfStream) {
        byte[] responseBody = this.handler.getHttpResponseBody();
        int result = this.proxyWasm.abi().proxyOnResponseBody(this.id, Helpers.len(responseBody), endOfStream ? 1 : 0);
        Action action = Action.fromInt(result);
        this.handler.setAction(StreamType.RESPONSE, action);
        return action;
    }
}

