/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import com.dylibso.chicory.runtime.ByteArrayMemory;
import com.dylibso.chicory.runtime.HostFunction;
import com.dylibso.chicory.runtime.ImportFunction;
import com.dylibso.chicory.runtime.ImportMemory;
import com.dylibso.chicory.runtime.ImportValues;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.runtime.Memory;
import com.dylibso.chicory.wasi.WasiOptions;
import com.dylibso.chicory.wasi.WasiPreview1;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.types.MemoryLimits;
import com.dylibso.chicory.wasm.types.ValueType;
import io.roastedroot.proxywasm.StartException;
import io.roastedroot.proxywasm.internal.ABI;
import io.roastedroot.proxywasm.internal.ABI_ModuleFactory;
import io.roastedroot.proxywasm.internal.ArrayBytesProxyMap;
import io.roastedroot.proxywasm.internal.ChainedHandler;
import io.roastedroot.proxywasm.internal.Context;
import io.roastedroot.proxywasm.internal.Handler;
import io.roastedroot.proxywasm.internal.Helpers;
import io.roastedroot.proxywasm.internal.HttpContext;
import io.roastedroot.proxywasm.internal.NetworkContext;
import io.roastedroot.proxywasm.internal.PluginContext;
import io.roastedroot.proxywasm.internal.ProxyMap;
import io.roastedroot.proxywasm.internal.WasmResult;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public final class ProxyWasm
implements Closeable {
    private final ABI abi;
    private final WasiPreview1 wasi;
    private final AtomicInteger nextContextID = new AtomicInteger(1);
    private Context pluginContext;
    private Context activeContext;
    private HashMap<Integer, Context> contexts = new HashMap();
    private ProxyMap httpCallResponseHeaders;
    private ProxyMap httpCallResponseTrailers;
    private byte[] httpCallResponseBody;
    private Handler pluginHandler;
    private ArrayBytesProxyMap grpcReceiveInitialMetadata;
    private byte[] grpcReceive;
    private ArrayBytesProxyMap grpcReceiveTrailingMetadata;

    private ProxyWasm(Builder other) throws StartException {
        this.pluginHandler = Objects.requireNonNullElse(other.pluginHandler, new Handler(){});
        this.wasi = other.wasi;
        this.abi = other.abi;
        this.abi.setHandler(this.createImportsHandler());
        if (this.abi.initialize()) {
            this.abi.main(0, 0);
        } else {
            this.abi.start();
        }
        if (other.start) {
            this.start();
        }
    }

    public Handler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(Handler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public void start() throws StartException {
        if (this.pluginContext != null) {
            return;
        }
        this.pluginContext = new PluginContext(this, this.pluginHandler);
        this.registerContext(this.pluginContext, 0);
        byte[] vmConfig = this.pluginHandler.getVmConfig();
        if (!this.abi.proxyOnVmStart(this.pluginContext.id(), Helpers.len(vmConfig))) {
            throw new StartException("proxy_on_vm_start failed");
        }
        byte[] pluginConfig = this.pluginHandler.getPluginConfig();
        if (!this.abi.proxyOnConfigure(this.pluginContext.id(), Helpers.len(pluginConfig))) {
            throw new StartException("proxy_on_configure failed");
        }
    }

    private void registerContext(Context context, int parentContextID) {
        this.contexts.put(context.id(), context);
        this.activeContext = context;
        this.abi.proxyOnContextCreate(context.id(), parentContextID);
    }

    private ChainedHandler createImportsHandler() {
        return new ChainedHandler(){

            @Override
            protected Handler next() {
                return ProxyWasm.this.activeContext.handler();
            }

            @Override
            public WasmResult setEffectiveContextID(int contextID) {
                Context context = ProxyWasm.this.contexts.get(contextID);
                if (context == null) {
                    return WasmResult.BAD_ARGUMENT;
                }
                ProxyWasm.this.activeContext = context;
                return WasmResult.OK;
            }

            @Override
            public WasmResult done() {
                return ProxyWasm.this.activeContext.done();
            }

            @Override
            public ProxyMap getHttpCallResponseHeaders() {
                return ProxyWasm.this.httpCallResponseHeaders;
            }

            @Override
            public ProxyMap getHttpCallResponseTrailers() {
                return ProxyWasm.this.httpCallResponseTrailers;
            }

            @Override
            public byte[] getHttpCallResponseBody() {
                return ProxyWasm.this.httpCallResponseBody;
            }

            @Override
            public ProxyMap getGrpcReceiveInitialMetaData() {
                return ProxyWasm.this.grpcReceiveInitialMetadata;
            }

            @Override
            public byte[] getGrpcReceiveBuffer() {
                return ProxyWasm.this.grpcReceive;
            }

            @Override
            public ProxyMap getGrpcReceiveTrailerMetaData() {
                return ProxyWasm.this.grpcReceiveTrailingMetadata;
            }
        };
    }

    HashMap<Integer, Context> contexts() {
        return this.contexts;
    }

    Context getActiveContext() {
        return this.activeContext;
    }

    void setActiveContext(Context activeContext) {
        if (activeContext == null) {
            activeContext = this.pluginContext;
        }
        this.activeContext = activeContext;
    }

    int nextContextID() {
        return this.nextContextID.getAndIncrement();
    }

    public HttpContext createHttpContext(Handler handler) {
        HttpContext context = new HttpContext(this, handler);
        this.registerContext(context, this.pluginContext.id());
        return context;
    }

    public NetworkContext createNetworkContext(Handler handler) {
        NetworkContext context = new NetworkContext(this, handler);
        this.registerContext(context, this.pluginContext.id());
        return context;
    }

    public void tick() {
        this.abi.proxyOnTick(this.pluginContext.id());
    }

    @Override
    public void close() {
        if (this.pluginContext == null) {
            return;
        }
        this.pluginContext.close();
        if (this.wasi != null) {
            this.wasi.close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public void sendHttpCallResponse(int calloutID, Map<String, String> headers, Map<String, String> trailers, byte[] body) {
        this.sendHttpCallResponse(calloutID, ProxyMap.copyOf(headers), ProxyMap.copyOf(trailers), body);
    }

    public void sendHttpCallResponse(int calloutID, ProxyMap headers, ProxyMap trailers, byte[] body) {
        this.httpCallResponseHeaders = headers;
        this.httpCallResponseTrailers = trailers;
        this.httpCallResponseBody = body;
        this.abi.proxyOnHttpCallResponse(this.pluginContext.id(), calloutID, Helpers.len(headers), Helpers.len(body), Helpers.len(trailers));
        this.httpCallResponseHeaders = null;
        this.httpCallResponseTrailers = null;
        this.httpCallResponseBody = null;
    }

    public void sendGrpcReceiveInitialMetadata(int calloutID, ArrayBytesProxyMap headers) {
        this.grpcReceiveInitialMetadata = headers;
        this.abi.proxyOnGrpcReceiveInitialMetadata(this.pluginContext.id(), calloutID, headers.size());
        this.grpcReceiveInitialMetadata = null;
    }

    public void sendGrpcReceive(int calloutID, byte[] body) {
        this.grpcReceive = body;
        this.abi.proxyOnGrpcReceive(this.pluginContext.id(), calloutID, Helpers.len(body));
        this.grpcReceive = null;
    }

    public void sendGrpcReceiveTrailingMetadata(int calloutID, ArrayBytesProxyMap headers) {
        this.grpcReceiveTrailingMetadata = headers;
        this.abi.proxyOnGrpcReceiveTrailingMetadata(this.pluginContext.id(), calloutID, headers.size());
        this.grpcReceiveTrailingMetadata = null;
    }

    public void sendGrpcClose(int calloutID, int statusCode) {
        this.abi.proxyOnGrpcClose(this.pluginContext.id(), calloutID, statusCode);
    }

    public void sendOnQueueReady(int queueId) {
        this.abi.proxyOnQueueReady(this.pluginContext.id(), queueId);
    }

    public int contextId() {
        return this.pluginContext.id();
    }

    ABI abi() {
        return this.abi;
    }

    public static class Builder
    implements Cloneable {
        private final ABI abi = new ABI();
        private WasiPreview1 wasi;
        private Handler pluginHandler;
        private ImportMemory memory;
        private WasiOptions wasiOptions;
        private boolean start = true;
        private Function<Instance, Machine> machineFactory;

        protected Builder clone() {
            try {
                return (Builder)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public HostFunction[] toHostFunctions() {
            return ABI_ModuleFactory.toHostFunctions(this.abi);
        }

        public Builder withStart(boolean start) {
            this.start = start;
            return this;
        }

        public Builder withPluginHandler(Handler vmHandler) {
            this.pluginHandler = vmHandler;
            return this;
        }

        public Builder withImportMemory(ImportMemory memory) {
            this.memory = memory;
            return this;
        }

        public Builder withWasiOptions(WasiOptions options) {
            this.wasiOptions = options;
            return this;
        }

        public Builder withMachineFactory(Function<Instance, Machine> machineFactory) {
            this.machineFactory = machineFactory;
            return this;
        }

        Builder() {
        }

        public ProxyWasm build(Instance instance) throws StartException {
            this.abi.setInstance(instance);
            return new ProxyWasm(this.clone());
        }

        public ProxyWasm build(WasmModule module) throws StartException {
            return this.build(Instance.builder((WasmModule)module));
        }

        public ProxyWasm build(Instance.Builder instanceBuilder) throws StartException {
            ImportValues.Builder imports = ImportValues.builder();
            if (this.machineFactory != null) {
                instanceBuilder.withMachineFactory(this.machineFactory);
            }
            imports.addMemory(new ImportMemory[]{Objects.requireNonNullElseGet(this.memory, this::defaultImportMemory)});
            imports.addFunction((ImportFunction[])this.toHostFunctions());
            imports.addFunction(new ImportFunction[]{new HostFunction("env", "emscripten_notify_memory_growth", List.of(ValueType.I32), List.of(), (inst, args) -> null)});
            this.wasi = WasiPreview1.builder().withOptions(Objects.requireNonNullElseGet(this.wasiOptions, () -> WasiOptions.builder().inheritSystem().withArguments(List.of()).build())).build();
            imports.addFunction((ImportFunction[])this.wasi.toHostFunctions());
            imports.addFunction((ImportFunction[])Helpers.withModuleName(this.wasi.toHostFunctions(), "wasi_unstable"));
            Instance instance = instanceBuilder.withStart(false).withImportValues(imports.build()).build();
            return this.build(instance);
        }

        ImportMemory defaultImportMemory() {
            return new ImportMemory("env", "memory", (Memory)new ByteArrayMemory(new MemoryLimits(2, 65536)));
        }

        WasiOptions defaultWasiOptions() {
            return WasiOptions.builder().inheritSystem().build();
        }
    }
}

