/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.internal.ProxyMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class SplitProxyMap
implements ProxyMap {
    private final ProxyMap primary;
    private final ProxyMap secondary;

    public SplitProxyMap(ProxyMap primary, ProxyMap secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public int size() {
        return this.primary.size() + this.secondary.size();
    }

    @Override
    public void add(String key, String value) {
        this.secondary.add(key, value);
    }

    @Override
    public void put(String key, String value) {
        if (this.primary.get(key) != null) {
            this.primary.put(key, value);
        }
        this.secondary.put(key, value);
    }

    @Override
    public Iterable<? extends Map.Entry<String, String>> entries() {
        return Stream.concat(StreamSupport.stream(this.primary.entries().spliterator(), false), StreamSupport.stream(this.secondary.entries().spliterator(), false)).collect(Collectors.toList());
    }

    @Override
    public String get(String key) {
        String value = this.primary.get(key);
        if (value != null) {
            return value;
        }
        return this.secondary.get(key);
    }

    @Override
    public void remove(String key) {
        this.secondary.remove(key);
    }
}

