/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm;

import io.roastedroot.proxywasm.LogLevel;
import io.roastedroot.proxywasm.WasmException;

public interface LogHandler {
    public static final LogHandler DEFAULT = new LogHandler(){

        @Override
        public LogLevel getLogLevel() throws WasmException {
            return LogLevel.CRITICAL;
        }
    };
    public static final LogHandler SYSTEM = new LogHandler(){

        @Override
        public void log(LogLevel level, String message) throws WasmException {
            System.out.println(String.valueOf((Object)level) + ": " + message);
        }
    };

    default public void log(LogLevel level, String message) throws WasmException {
    }

    default public LogLevel getLogLevel() throws WasmException {
        return LogLevel.TRACE;
    }
}

