/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm;

import com.dylibso.chicory.runtime.ImportMemory;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import com.dylibso.chicory.wasi.WasiOptions;
import com.dylibso.chicory.wasm.WasmModule;
import io.roastedroot.proxywasm.ForeignFunction;
import io.roastedroot.proxywasm.LogHandler;
import io.roastedroot.proxywasm.MetricsHandler;
import io.roastedroot.proxywasm.SharedDataHandler;
import io.roastedroot.proxywasm.SharedQueueHandler;
import io.roastedroot.proxywasm.internal.Helpers;
import io.roastedroot.proxywasm.internal.Plugin;
import io.roastedroot.proxywasm.internal.ProxyWasm;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public interface PluginFactory {
    public io.roastedroot.proxywasm.Plugin create() throws Exception;

    public String name();

    public boolean shared();

    public static Builder builder(WasmModule module) {
        return new Builder(module);
    }

    public static final class Builder {
        private final WasmModule module;
        private final ProxyWasm.Builder proxyWasmBuilder = ProxyWasm.builder().withStart(false);
        private String name;
        private HashMap<String, ForeignFunction> foreignFunctions;
        private HashMap<String, URI> upstreams;
        private boolean strictUpstreams;
        private int minTickPeriodMilliseconds;
        private LogHandler logger;
        private byte[] vmConfig;
        private byte[] pluginConfig;
        private MetricsHandler metricsHandler;
        private SharedQueueHandler sharedQueueHandler;
        private SharedDataHandler sharedDataHandler;
        private boolean shared;

        private Builder(WasmModule module) {
            this.module = module;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withForeignFunctions(Map<String, ForeignFunction> functions) {
            this.foreignFunctions = new HashMap<String, ForeignFunction>(functions);
            return this;
        }

        public Builder withUpstreams(Map<String, URI> upstreams) {
            this.upstreams = new HashMap<String, URI>(upstreams);
            return this;
        }

        public Builder withStrictUpstreams(boolean strictUpstreams) {
            this.strictUpstreams = strictUpstreams;
            return this;
        }

        public Builder withMinTickPeriodMilliseconds(int minTickPeriodMilliseconds) {
            this.minTickPeriodMilliseconds = minTickPeriodMilliseconds;
            return this;
        }

        public Builder withLogger(LogHandler logger) {
            this.logger = logger;
            return this;
        }

        public Builder withMetricsHandler(MetricsHandler metricsHandler) {
            this.metricsHandler = metricsHandler;
            return this;
        }

        public Builder withSharedQueueHandler(SharedQueueHandler sharedQueueHandler) {
            this.sharedQueueHandler = sharedQueueHandler;
            return this;
        }

        public Builder withSharedDataHandler(SharedDataHandler sharedDataHandler) {
            this.sharedDataHandler = sharedDataHandler;
            return this;
        }

        public Builder withVmConfig(byte[] vmConfig) {
            this.vmConfig = vmConfig;
            return this;
        }

        public Builder withVmConfig(String vmConfig) {
            this.vmConfig = Helpers.bytes(vmConfig);
            return this;
        }

        public Builder withPluginConfig(byte[] pluginConfig) {
            this.pluginConfig = pluginConfig;
            return this;
        }

        public Builder withPluginConfig(String pluginConfig) {
            this.pluginConfig = Helpers.bytes(pluginConfig);
            return this;
        }

        public Builder withImportMemory(ImportMemory memory) {
            this.proxyWasmBuilder.withImportMemory(memory);
            return this;
        }

        public Builder withMachineFactory(Function<Instance, Machine> machineFactory) {
            this.proxyWasmBuilder.withMachineFactory(machineFactory);
            return this;
        }

        public Builder withWasiOptions(WasiOptions options) {
            this.proxyWasmBuilder.withWasiOptions(options);
            return this;
        }

        public Builder withShared(boolean shared) {
            this.shared = shared;
            return this;
        }

        public PluginFactory build() {
            final String name = this.name;
            final HashMap<String, ForeignFunction> foreignFunctions = this.foreignFunctions != null ? new HashMap<String, ForeignFunction>(this.foreignFunctions) : null;
            final HashMap<String, URI> upstreams = this.upstreams != null ? new HashMap<String, URI>(this.upstreams) : null;
            final boolean strictUpstreams = this.strictUpstreams;
            final int minTickPeriodMilliseconds = this.minTickPeriodMilliseconds;
            final LogHandler logger = this.logger;
            final byte[] vmConfig = this.vmConfig != null ? (byte[])this.vmConfig.clone() : null;
            final byte[] pluginConfig = this.pluginConfig != null ? (byte[])this.pluginConfig.clone() : null;
            final MetricsHandler metricsHandler = this.metricsHandler;
            final SharedQueueHandler sharedQueueHandler = this.sharedQueueHandler;
            final SharedDataHandler sharedDataHandler = this.sharedDataHandler;
            final boolean shared = this.shared;
            return new PluginFactory(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public boolean shared() {
                    return shared;
                }

                @Override
                public io.roastedroot.proxywasm.Plugin create() throws Exception {
                    return new Plugin(proxyWasmBuilder.build(module), name, foreignFunctions, upstreams, strictUpstreams, minTickPeriodMilliseconds, logger, vmConfig, pluginConfig, metricsHandler, sharedQueueHandler, sharedDataHandler);
                }
            };
        }
    }
}

