/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.internal.Handler;
import io.roastedroot.proxywasm.internal.ProxyWasm;
import io.roastedroot.proxywasm.internal.WasmResult;
import java.io.Closeable;

public abstract class Context
implements Closeable {
    ProxyWasm proxyWasm;
    final int id;
    boolean closeDone;
    boolean closeStarted;

    Context(ProxyWasm proxyWasm) {
        this.proxyWasm = proxyWasm;
        this.id = proxyWasm.nextContextID();
    }

    abstract Handler handler();

    public int id() {
        return this.id;
    }

    public ProxyWasm getProxyWasm() {
        return this.proxyWasm;
    }

    ProxyWasm proxyWasm() {
        return this.proxyWasm;
    }

    @Override
    public void close() {
        if (this.closeStarted) {
            return;
        }
        this.closeStarted = true;
        if (!this.closeDone && this.proxyWasm.abi().proxyOnDone(this.id)) {
            this.finishClose();
        }
    }

    WasmResult done() {
        if (!this.closeStarted) {
            return WasmResult.NOT_FOUND;
        }
        if (!this.closeDone) {
            this.finishClose();
        }
        return WasmResult.OK;
    }

    protected void finishClose() {
        this.closeDone = true;
        this.proxyWasm.abi().proxyOnLog(this.id);
        this.proxyWasm.contexts().remove(this.id);
        assert (this.proxyWasm.getActiveContext() == this) : "we are the active context";
        this.proxyWasm.setActiveContext(null);
        this.proxyWasm.abi().proxyOnDelete(this.id);
    }
}

