/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;

public class HttpRequestBody {
    private byte[] body;
    private boolean loaded = false;
    private final Supplier<InputStream> streamSupplier;

    public HttpRequestBody(Supplier<InputStream> streamSupplier) {
        this.streamSupplier = streamSupplier;
    }

    public byte[] get() {
        if (!this.loaded) {
            try {
                this.body = this.streamSupplier.get().readAllBytes();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read request body", e);
            }
            this.loaded = true;
        }
        return this.body;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setBody(byte[] body) {
        this.body = body;
        this.loaded = true;
    }

    public byte[] getBodyIfLoaded() {
        return this.loaded ? this.body : null;
    }
}

