/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.ForeignFunction;
import io.roastedroot.proxywasm.LogHandler;
import io.roastedroot.proxywasm.LogLevel;
import io.roastedroot.proxywasm.MetricType;
import io.roastedroot.proxywasm.MetricsHandler;
import io.roastedroot.proxywasm.QueueName;
import io.roastedroot.proxywasm.SharedData;
import io.roastedroot.proxywasm.SharedDataHandler;
import io.roastedroot.proxywasm.SharedQueueHandler;
import io.roastedroot.proxywasm.StartException;
import io.roastedroot.proxywasm.WasmException;
import io.roastedroot.proxywasm.internal.ArrayBytesProxyMap;
import io.roastedroot.proxywasm.internal.ArrayProxyMap;
import io.roastedroot.proxywasm.internal.ChainedHandler;
import io.roastedroot.proxywasm.internal.GrpcCallResponseHandler;
import io.roastedroot.proxywasm.internal.Handler;
import io.roastedroot.proxywasm.internal.Helpers;
import io.roastedroot.proxywasm.internal.HttpRequestAdaptor;
import io.roastedroot.proxywasm.internal.PluginHttpContext;
import io.roastedroot.proxywasm.internal.ProxyMap;
import io.roastedroot.proxywasm.internal.ProxyWasm;
import io.roastedroot.proxywasm.internal.ServerAdaptor;
import io.roastedroot.proxywasm.internal.WasmResult;
import io.roastedroot.proxywasm.internal.WellKnownProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public final class Plugin
implements io.roastedroot.proxywasm.Plugin {
    private final ReentrantLock lock = new ReentrantLock();
    final ProxyWasm wasm;
    ServerAdaptor serverAdaptor;
    private final String name;
    private final MetricsHandler metricsHandler;
    private final SharedQueueHandler sharedQueueHandler;
    private final SharedDataHandler sharedDataHandler;
    public LogHandler logger;
    static final boolean DEBUG = "true".equals(System.getenv("DEBUG"));
    byte[] vmConfig;
    byte[] pluginConfig;
    private final AtomicInteger lastCallId = new AtomicInteger(0);
    private final HashMap<Integer, Runnable> httpCalls = new HashMap();
    private final HashMap<Integer, Runnable> grpcCalls = new HashMap();
    private final HashMap<String, URI> upstreams;
    boolean strictUpstreams;
    int minTickPeriodMilliseconds;
    private int tickPeriodMilliseconds;
    private Runnable cancelTick;
    private final HashMap<String, ForeignFunction> foreignFunctions;
    private byte[] funcCallData = new byte[0];
    private final HashMap<List<String>, byte[]> properties = new HashMap();

    public Plugin(ProxyWasm proxyWasm, String name, HashMap<String, ForeignFunction> foreignFunctions, HashMap<String, URI> upstreams, boolean strictUpstreams, int minTickPeriodMilliseconds, LogHandler logger, byte[] vmConfig, byte[] pluginConfig, MetricsHandler metricsHandler, SharedQueueHandler sharedQueueHandler, SharedDataHandler sharedDataHandler) throws StartException {
        Objects.requireNonNull(proxyWasm);
        this.name = Objects.requireNonNullElse(name, "default");
        this.foreignFunctions = Objects.requireNonNullElseGet(foreignFunctions, HashMap::new);
        this.upstreams = Objects.requireNonNullElseGet(upstreams, HashMap::new);
        this.strictUpstreams = strictUpstreams;
        this.minTickPeriodMilliseconds = minTickPeriodMilliseconds;
        this.vmConfig = vmConfig;
        this.pluginConfig = pluginConfig;
        this.logger = Objects.requireNonNullElse(logger, LogHandler.DEFAULT);
        this.metricsHandler = Objects.requireNonNullElse(metricsHandler, MetricsHandler.DEFAULT);
        this.sharedQueueHandler = Objects.requireNonNullElse(sharedQueueHandler, SharedQueueHandler.DEFAULT);
        this.sharedDataHandler = Objects.requireNonNullElse(sharedDataHandler, SharedDataHandler.DEFAULT);
        this.wasm = proxyWasm;
        this.wasm.setPluginHandler(new HandlerImpl());
        this.wasm.start();
    }

    @Override
    public String name() {
        return this.name;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public ServerAdaptor getServerAdaptor() {
        return this.serverAdaptor;
    }

    public void setServerAdaptor(ServerAdaptor serverAdaptor) {
        this.serverAdaptor = serverAdaptor;
    }

    public LogHandler logger() {
        return this.logger;
    }

    public PluginHttpContext createHttpContext(HttpRequestAdaptor requestAdaptor) {
        return new PluginHttpContext(this, requestAdaptor);
    }

    public void close() {
        this.lock();
        try {
            this.wasm.close();
            if (this.cancelTick != null) {
                this.cancelTick.run();
                this.cancelTick = null;
            }
            for (Runnable cancel : this.httpCalls.values()) {
                cancel.run();
            }
            this.httpCalls.clear();
            for (Runnable cancel : this.grpcCalls.values()) {
                cancel.run();
            }
            this.grpcCalls.clear();
        }
        finally {
            this.unlock();
        }
    }

    class HandlerImpl
    extends ChainedHandler {
        HandlerImpl() {
        }

        @Override
        protected Handler next() {
            return Handler.DEFAULT;
        }

        @Override
        public byte[] getVmConfig() {
            return Plugin.this.vmConfig;
        }

        @Override
        public byte[] getPluginConfig() {
            return Plugin.this.pluginConfig;
        }

        @Override
        public byte[] getProperty(List<String> path) throws WasmException {
            if (WellKnownProperties.PLUGIN_VM_ID.equals(path)) {
                return Helpers.bytes(Plugin.this.name);
            }
            if (WellKnownProperties.PLUGIN_NAME.equals(path)) {
                return Helpers.bytes(Plugin.this.name);
            }
            return Plugin.this.properties.get(path);
        }

        @Override
        public WasmResult setProperty(List<String> path, byte[] value) {
            Plugin.this.properties.put(path, value);
            return WasmResult.OK;
        }

        @Override
        public void log(LogLevel level, String message) throws WasmException {
            Plugin.this.logger.log(level, message);
        }

        @Override
        public LogLevel getLogLevel() throws WasmException {
            return Plugin.this.logger.getLogLevel();
        }

        @Override
        public WasmResult setTickPeriodMilliseconds(int tickMs) {
            if (tickMs == Plugin.this.tickPeriodMilliseconds) {
                return WasmResult.OK;
            }
            if (Plugin.this.cancelTick != null) {
                Plugin.this.cancelTick.run();
                Plugin.this.cancelTick = null;
            }
            Plugin.this.tickPeriodMilliseconds = tickMs;
            if (Plugin.this.tickPeriodMilliseconds == 0) {
                return WasmResult.OK;
            }
            Plugin.this.cancelTick = Plugin.this.serverAdaptor.scheduleTick(Math.max(Plugin.this.minTickPeriodMilliseconds, Plugin.this.tickPeriodMilliseconds), () -> {
                Plugin.this.lock();
                try {
                    Plugin.this.wasm.tick();
                }
                finally {
                    Plugin.this.unlock();
                }
            });
            return WasmResult.OK;
        }

        @Override
        public byte[] getFuncCallData() {
            return Plugin.this.funcCallData;
        }

        @Override
        public WasmResult setFuncCallData(byte[] data) {
            Plugin.this.funcCallData = data;
            return WasmResult.OK;
        }

        @Override
        public int httpCall(String upstreamName, ProxyMap headers, byte[] body, ProxyMap trailers, int timeoutMilliseconds) throws WasmException {
            Object path;
            String authority;
            String method = headers.get(":method");
            if (method == null) {
                throw new WasmException(WasmResult.BAD_ARGUMENT);
            }
            String scheme = headers.get(":scheme");
            if (scheme == null) {
                scheme = "http";
            }
            if ((authority = headers.get(":authority")) == null) {
                throw new WasmException(WasmResult.BAD_ARGUMENT);
            }
            headers.put("Host", authority);
            URI connectUri = Plugin.this.upstreams.get(upstreamName);
            if (connectUri == null && Plugin.this.strictUpstreams) {
                throw new WasmException(WasmResult.BAD_ARGUMENT);
            }
            if (connectUri == null) {
                try {
                    connectUri = new URI(upstreamName);
                }
                catch (URISyntaxException e) {
                    throw new WasmException(WasmResult.BAD_ARGUMENT);
                }
            }
            String connectHost = connectUri.getHost();
            int connectPort = connectUri.getPort();
            if (connectPort == -1) {
                int n = connectPort = "https".equals(scheme) ? 443 : 80;
            }
            if ((path = headers.get(":path")) == null) {
                throw new WasmException(WasmResult.BAD_ARGUMENT);
            }
            if (!((String)path).isEmpty() && !((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            URI uri = null;
            try {
                uri = URI.create(scheme + "://" + authority + (String)path);
            }
            catch (IllegalArgumentException e) {
                throw new WasmException(WasmResult.BAD_ARGUMENT);
            }
            for (Map.Entry<String, String> entry : new ArrayProxyMap(headers).entries()) {
                if (!entry.getKey().startsWith(":")) continue;
                headers.remove(entry.getKey());
            }
            try {
                int id = Plugin.this.lastCallId.incrementAndGet();
                Runnable runnable = Plugin.this.serverAdaptor.scheduleHttpCall(method, connectHost, connectPort, uri, headers, body, trailers, timeoutMilliseconds, (statusCode, respHeaders, respBody) -> {
                    Plugin.this.lock();
                    try {
                        if (Plugin.this.httpCalls.remove(id) == null) {
                            return;
                        }
                        Plugin.this.wasm.sendHttpCallResponse(id, respHeaders, new ArrayProxyMap(), respBody);
                    }
                    finally {
                        Plugin.this.unlock();
                    }
                });
                Plugin.this.httpCalls.put(id, runnable);
                return id;
            }
            catch (InterruptedException e) {
                throw new WasmException(WasmResult.INTERNAL_FAILURE);
            }
            catch (UnsupportedOperationException e) {
                throw new WasmException(WasmResult.UNIMPLEMENTED);
            }
        }

        @Override
        public int dispatchHttpCall(String upstreamName, ProxyMap headers, byte[] body, ProxyMap trailers, int timeoutMilliseconds) throws WasmException {
            return this.httpCall(upstreamName, headers, body, trailers, timeoutMilliseconds);
        }

        @Override
        public int grpcCall(String upstreamName, String serviceName, String methodName, ProxyMap headers, byte[] body, int timeoutMilliseconds) throws WasmException {
            URI connectUri = Plugin.this.upstreams.get(upstreamName);
            if (connectUri == null && Plugin.this.strictUpstreams) {
                throw new WasmException(WasmResult.BAD_ARGUMENT);
            }
            if (connectUri == null) {
                try {
                    connectUri = new URI(upstreamName);
                }
                catch (URISyntaxException e) {
                    throw new WasmException(WasmResult.BAD_ARGUMENT);
                }
            }
            if (!"http".equals(connectUri.getScheme()) && !"https".equals(connectUri.getScheme())) {
                Plugin.this.logger.log(LogLevel.ERROR, "grpc call upstream not mapped to URL with a http/https scheme: " + upstreamName);
                throw new WasmException(WasmResult.BAD_ARGUMENT);
            }
            String connectHost = connectUri.getHost();
            int connectPort = connectUri.getPort();
            if (connectPort == -1) {
                connectPort = "https".equals(connectUri.getScheme()) ? 443 : 80;
            }
            try {
                final int id = Plugin.this.lastCallId.incrementAndGet();
                GrpcCallResponseHandler callHandler = new GrpcCallResponseHandler(){

                    @Override
                    public void onHeaders(ArrayBytesProxyMap headers) {
                        Plugin.this.lock();
                        try {
                            if (Plugin.this.grpcCalls.get(id) == null) {
                                return;
                            }
                            Plugin.this.wasm.sendGrpcReceiveInitialMetadata(id, headers);
                        }
                        finally {
                            Plugin.this.unlock();
                        }
                    }

                    @Override
                    public void onMessage(byte[] data) {
                        Plugin.this.lock();
                        try {
                            if (Plugin.this.grpcCalls.get(id) == null) {
                                return;
                            }
                            Plugin.this.wasm.sendGrpcReceive(id, data);
                        }
                        finally {
                            Plugin.this.unlock();
                        }
                    }

                    @Override
                    public void onTrailers(ArrayBytesProxyMap trailers) {
                        Plugin.this.lock();
                        try {
                            if (Plugin.this.grpcCalls.get(id) == null) {
                                return;
                            }
                            Plugin.this.wasm.sendGrpcReceiveTrailingMetadata(id, trailers);
                        }
                        finally {
                            Plugin.this.unlock();
                        }
                    }

                    @Override
                    public void onClose(int status) {
                        Plugin.this.lock();
                        try {
                            if (Plugin.this.grpcCalls.get(id) == null) {
                                return;
                            }
                            Plugin.this.wasm.sendGrpcClose(id, status);
                        }
                        finally {
                            Plugin.this.unlock();
                        }
                    }
                };
                Runnable future = Plugin.this.serverAdaptor.scheduleGrpcCall(connectHost, connectPort, "http".equals(connectUri.getScheme()), serviceName, methodName, headers, body, timeoutMilliseconds, callHandler);
                Plugin.this.grpcCalls.put(id, future);
                return id;
            }
            catch (InterruptedException e) {
                throw new WasmException(WasmResult.INTERNAL_FAILURE);
            }
            catch (UnsupportedOperationException e) {
                throw new WasmException(WasmResult.UNIMPLEMENTED);
            }
        }

        @Override
        public int defineMetric(MetricType type, String name) throws WasmException {
            return Plugin.this.metricsHandler.defineMetric(type, name);
        }

        @Override
        public long getMetric(int metricId) throws WasmException {
            return Plugin.this.metricsHandler.getMetric(metricId);
        }

        @Override
        public WasmResult incrementMetric(int metricId, long value) {
            return Plugin.this.metricsHandler.incrementMetric(metricId, value);
        }

        @Override
        public WasmResult recordMetric(int metricId, long value) {
            return Plugin.this.metricsHandler.recordMetric(metricId, value);
        }

        @Override
        public WasmResult removeMetric(int metricId) {
            return Plugin.this.metricsHandler.removeMetric(metricId);
        }

        @Override
        public ForeignFunction getForeignFunction(String name) {
            return Plugin.this.foreignFunctions.get(name);
        }

        @Override
        public SharedData getSharedData(String key) throws WasmException {
            return Plugin.this.sharedDataHandler.getSharedData(key);
        }

        @Override
        public WasmResult setSharedData(String key, byte[] value, int cas) {
            return Plugin.this.sharedDataHandler.setSharedData(key, value, cas);
        }

        @Override
        public int registerSharedQueue(QueueName queueName) throws WasmException {
            return Plugin.this.sharedQueueHandler.registerSharedQueue(queueName);
        }

        @Override
        public int resolveSharedQueue(QueueName queueName) throws WasmException {
            return Plugin.this.sharedQueueHandler.resolveSharedQueue(queueName);
        }

        @Override
        public byte[] dequeueSharedQueue(int queueId) throws WasmException {
            return Plugin.this.sharedQueueHandler.dequeueSharedQueue(queueId);
        }

        @Override
        public WasmResult enqueueSharedQueue(int queueId, byte[] value) {
            return Plugin.this.sharedQueueHandler.enqueueSharedQueue(queueId, value);
        }
    }
}

