/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.WasmException;
import io.roastedroot.proxywasm.internal.Action;
import io.roastedroot.proxywasm.internal.ChainedHandler;
import io.roastedroot.proxywasm.internal.Handler;
import io.roastedroot.proxywasm.internal.Helpers;
import io.roastedroot.proxywasm.internal.HttpContext;
import io.roastedroot.proxywasm.internal.HttpRequestAdaptor;
import io.roastedroot.proxywasm.internal.HttpRequestBody;
import io.roastedroot.proxywasm.internal.HttpResponseBody;
import io.roastedroot.proxywasm.internal.Plugin;
import io.roastedroot.proxywasm.internal.ProxyMap;
import io.roastedroot.proxywasm.internal.SendResponse;
import io.roastedroot.proxywasm.internal.StreamType;
import io.roastedroot.proxywasm.internal.WasmResult;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class PluginHttpContext {
    private final Plugin plugin;
    private final HttpContext context;
    private final HttpRequestAdaptor requestAdaptor;
    private final long startedAt = System.currentTimeMillis();
    final HashMap<List<String>, byte[]> properties = new HashMap();
    private HttpRequestBody httpRequestBodyState;
    private HttpResponseBody httpResponseBodyState;
    private byte[] grpcReceiveBuffer = new byte[0];
    private byte[] upstreamData = new byte[0];
    private byte[] downStreamData = new byte[0];
    private SendResponse sendResponse;
    private Action action;
    private CountDownLatch resumeLatch;

    public PluginHttpContext(Plugin plugin, HttpRequestAdaptor requestAdaptor) {
        this.plugin = plugin;
        this.requestAdaptor = requestAdaptor;
        this.context = plugin.wasm.createHttpContext(new HandlerImpl());
    }

    public void setHttpRequestBodyState(HttpRequestBody supplier) {
        this.httpRequestBodyState = supplier;
    }

    public HttpRequestBody getHttpRequestBodyState() {
        return this.httpRequestBodyState;
    }

    public byte[] getHttpRequestBody() {
        if (this.httpRequestBodyState != null) {
            return this.httpRequestBodyState.get();
        }
        return new byte[0];
    }

    public void setHttpRequestBody(byte[] body) {
        if (this.httpRequestBodyState != null && body != null) {
            this.httpRequestBodyState.setBody(body);
        }
    }

    public void setHttpResponseBodyState(HttpResponseBody responseBody) {
        this.httpResponseBodyState = responseBody;
    }

    public HttpResponseBody getHttpResponseBodyState() {
        return this.httpResponseBodyState;
    }

    public byte[] getHttpResponseBody() {
        if (this.httpResponseBodyState != null) {
            return this.httpResponseBodyState.get();
        }
        return new byte[0];
    }

    public void setHttpResponseBody(byte[] httpResponseBody) {
        if (this.httpResponseBodyState != null && httpResponseBody != null) {
            this.httpResponseBodyState.setBody(httpResponseBody);
        }
    }

    public Plugin plugin() {
        return this.plugin;
    }

    public HttpContext context() {
        return this.context;
    }

    public HttpRequestAdaptor requestAdaptor() {
        return this.requestAdaptor;
    }

    public Action getAction() {
        return this.action;
    }

    public void maybePause() {
        if (this.action == Action.CONTINUE) {
            return;
        }
        if (this.sendResponse != null) {
            return;
        }
        this.resumeLatch = new CountDownLatch(1);
        this.plugin.unlock();
        try {
            this.resumeLatch.await();
        }
        catch (InterruptedException ignore) {
            return;
        }
        finally {
            this.plugin.lock();
            this.resumeLatch = null;
        }
    }

    public byte[] getGrpcReceiveBuffer() {
        return this.grpcReceiveBuffer;
    }

    public void setGrpcReceiveBuffer(byte[] grpcReceiveBuffer) {
        this.grpcReceiveBuffer = grpcReceiveBuffer;
    }

    public byte[] getUpstreamData() {
        return this.upstreamData;
    }

    public void setUpstreamData(byte[] upstreamData) {
        this.upstreamData = upstreamData;
    }

    public byte[] getDownStreamData() {
        return this.downStreamData;
    }

    public void setDownStreamData(byte[] downStreamData) {
        this.downStreamData = downStreamData;
    }

    public SendResponse getSendResponse() {
        return this.sendResponse;
    }

    public SendResponse consumeSentHttpResponse() {
        SendResponse result = this.sendResponse;
        this.sendResponse = null;
        return result;
    }

    class HandlerImpl
    extends ChainedHandler {
        private final Handler next;

        HandlerImpl() {
            this.next = PluginHttpContext.this.plugin.wasm.getPluginHandler();
        }

        @Override
        protected Handler next() {
            return this.next;
        }

        @Override
        public ProxyMap getHttpRequestHeaders() {
            return PluginHttpContext.this.requestAdaptor.getHttpRequestHeaders();
        }

        @Override
        public ProxyMap getHttpRequestTrailers() {
            return PluginHttpContext.this.requestAdaptor.getHttpRequestTrailers();
        }

        @Override
        public ProxyMap getHttpResponseHeaders() {
            return PluginHttpContext.this.requestAdaptor.getHttpResponseHeaders();
        }

        @Override
        public ProxyMap getHttpResponseTrailers() {
            return PluginHttpContext.this.requestAdaptor.getHttpResponseTrailers();
        }

        @Override
        public ProxyMap getGrpcReceiveInitialMetaData() {
            return PluginHttpContext.this.requestAdaptor.getGrpcReceiveInitialMetaData();
        }

        @Override
        public ProxyMap getGrpcReceiveTrailerMetaData() {
            return PluginHttpContext.this.requestAdaptor.getGrpcReceiveTrailerMetaData();
        }

        @Override
        public byte[] getHttpRequestBody() {
            return PluginHttpContext.this.getHttpRequestBody();
        }

        @Override
        public WasmResult setHttpRequestBody(byte[] body) {
            PluginHttpContext.this.setHttpRequestBody(body);
            return WasmResult.OK;
        }

        public void appendHttpRequestBody(byte[] body) {
            byte[] currentBody = PluginHttpContext.this.getHttpRequestBody();
            PluginHttpContext.this.setHttpRequestBody(Helpers.append(currentBody, body));
        }

        @Override
        public byte[] getGrpcReceiveBuffer() {
            return PluginHttpContext.this.grpcReceiveBuffer;
        }

        @Override
        public WasmResult setGrpcReceiveBuffer(byte[] buffer) {
            PluginHttpContext.this.grpcReceiveBuffer = buffer;
            return WasmResult.OK;
        }

        @Override
        public byte[] getUpstreamData() {
            return PluginHttpContext.this.upstreamData;
        }

        @Override
        public WasmResult setUpstreamData(byte[] data) {
            PluginHttpContext.this.upstreamData = data;
            return WasmResult.OK;
        }

        @Override
        public byte[] getDownStreamData() {
            return PluginHttpContext.this.downStreamData;
        }

        @Override
        public WasmResult setDownStreamData(byte[] data) {
            PluginHttpContext.this.downStreamData = data;
            return WasmResult.OK;
        }

        @Override
        public byte[] getHttpResponseBody() {
            return PluginHttpContext.this.getHttpResponseBody();
        }

        @Override
        public WasmResult setHttpResponseBody(byte[] body) {
            PluginHttpContext.this.setHttpResponseBody(body);
            return WasmResult.OK;
        }

        public void appendHttpResponseBody(byte[] body) {
            byte[] currentBody = PluginHttpContext.this.getHttpResponseBody();
            PluginHttpContext.this.setHttpResponseBody(Helpers.append(currentBody, body));
        }

        @Override
        public WasmResult sendHttpResponse(int responseCode, byte[] responseCodeDetails, byte[] responseBody, ProxyMap additionalHeaders, int grpcStatus) {
            PluginHttpContext.this.sendResponse = new SendResponse(responseCode, responseCodeDetails, responseBody, additionalHeaders, grpcStatus);
            if (PluginHttpContext.this.resumeLatch != null) {
                PluginHttpContext.this.resumeLatch.countDown();
            }
            return WasmResult.OK;
        }

        @Override
        public WasmResult setAction(StreamType streamType, Action actionValue) {
            PluginHttpContext.this.action = actionValue;
            if (PluginHttpContext.this.action == Action.CONTINUE && PluginHttpContext.this.resumeLatch != null) {
                PluginHttpContext.this.resumeLatch.countDown();
            }
            return WasmResult.OK;
        }

        @Override
        public byte[] getProperty(List<String> path) throws WasmException {
            byte[] result = PluginHttpContext.this.requestAdaptor.getProperty(PluginHttpContext.this, path);
            if (result == null) {
                result = PluginHttpContext.this.properties.get(path);
            }
            return result;
        }

        @Override
        public WasmResult setProperty(List<String> path, byte[] value) {
            WasmResult result = PluginHttpContext.this.requestAdaptor.setProperty(PluginHttpContext.this, path, value);
            if (result == WasmResult.NOT_FOUND) {
                PluginHttpContext.this.properties.put(path, value);
            }
            return WasmResult.OK;
        }
    }
}

