/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.PluginFactory;
import io.roastedroot.proxywasm.StartException;
import io.roastedroot.proxywasm.internal.Plugin;
import io.roastedroot.proxywasm.internal.ServerAdaptor;

public interface Pool {
    public Plugin borrow() throws StartException;

    public String name();

    public void release(Plugin var1);

    default public void close() {
    }

    public static class PluginPerRequest
    implements Pool {
        private final ServerAdaptor serverAdaptor;
        final PluginFactory factory;

        public PluginPerRequest(ServerAdaptor serverAdaptor, PluginFactory factory) {
            this.serverAdaptor = serverAdaptor;
            this.factory = factory;
        }

        @Override
        public String name() {
            return this.factory.name();
        }

        @Override
        public Plugin borrow() throws StartException {
            Plugin plugin = null;
            try {
                plugin = (Plugin)this.factory.create();
            }
            catch (Throwable e) {
                throw new StartException("Plugin create failed.", e);
            }
            plugin.setServerAdaptor(this.serverAdaptor);
            plugin.wasm.start();
            return plugin;
        }

        @Override
        public void release(Plugin plugin) {
            plugin.close();
        }
    }

    public static class SharedPlugin
    implements Pool {
        private final ServerAdaptor serverAdaptor;
        private final PluginFactory factory;
        private Plugin plugin;

        public SharedPlugin(ServerAdaptor serverAdaptor, PluginFactory factory) {
            this.serverAdaptor = serverAdaptor;
            this.factory = factory;
        }

        @Override
        public String name() {
            return this.factory.name();
        }

        @Override
        public Plugin borrow() throws StartException {
            if (this.plugin != null) {
                return this.plugin;
            }
            try {
                this.plugin = (Plugin)this.factory.create();
            }
            catch (Throwable e) {
                throw new StartException("Plugin create failed.", e);
            }
            this.plugin.setServerAdaptor(this.serverAdaptor);
            this.plugin.wasm.start();
            return this.plugin;
        }

        @Override
        public void release(Plugin plugin) {
            if (plugin != this.plugin) {
                throw new IllegalArgumentException("Plugin not from this pool");
            }
        }
    }
}

