/*
 * Decompiled with CFR 0.152.
 */
package io.roastedroot.proxywasm.internal;

import io.roastedroot.proxywasm.WasmException;

public enum WasmResult {
    OK(0, "Operation completed successfully"),
    NOT_FOUND(1, "The result could not be found, e.g. a provided key did not appear in a table"),
    BAD_ARGUMENT(2, "An argument was bad, e.g. did not conform to the required range"),
    SERIALIZATION_FAILURE(3, "A protobuf could not be serialized"),
    PARSE_FAILURE(4, "A protobuf could not be parsed"),
    INVALID_MEMORY_ACCESS(6, "A provided memory range was not legal"),
    EMPTY(7, "Data was requested from an empty container"),
    CAS_MISMATCH(8, "The provided CAS did not match that of the stored data"),
    INTERNAL_FAILURE(10, "Internal failure: trying check logs of the surrounding system"),
    UNIMPLEMENTED(12, "Feature not implemented");

    private final int value;
    private final String description;

    private WasmResult(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int getValue() {
        return this.value;
    }

    public String description() {
        return this.description;
    }

    public static WasmResult fromInt(int value) {
        for (WasmResult result : WasmResult.values()) {
            if (result.value != value) continue;
            return result;
        }
        throw new IllegalArgumentException("Unknown WasmResult value: " + value);
    }

    public void expect(WasmResult ... expected) throws WasmException {
        for (WasmResult result : expected) {
            if (this != result) continue;
            return;
        }
        throw new WasmException(this);
    }
}

