/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.internal.streams;

import io.simplesource.api.CommandAPI;
import io.simplesource.api.CommandError;
import io.simplesource.data.NonEmptyList;
import io.simplesource.data.Result;
import io.simplesource.data.Sequence;
import io.simplesource.kafka.internal.streams.AggregateTestDriver;
import io.simplesource.kafka.model.AggregateUpdate;
import io.simplesource.kafka.model.AggregateUpdateResult;
import io.simplesource.kafka.model.ValueWithSequence;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.streams.KeyValue;
import org.junit.jupiter.api.Assertions;

public final class AggregateTestHelper<K, C, E, A> {
    private final AggregateTestDriver<K, C, E, A> testAPI;

    public AggregateTestHelper(AggregateTestDriver<K, C, E, A> testAPI) {
        this.testAPI = testAPI;
    }

    public PublishBuilder publishCommand(K key, Sequence readSequence, C command) {
        return new PublishBuilder(key, readSequence, command);
    }

    private UUID publish(K key, Sequence readSequence, C command) {
        UUID commandId = UUID.randomUUID();
        Result result = this.testAPI.publishCommand(new CommandAPI.Request(key, readSequence, commandId, command)).unsafePerform(AggregateTestHelper::commandError);
        return (UUID)result.fold(reasons -> (UUID)Assertions.fail((String)("Publishing command " + command + " failed with " + reasons)), uuid -> {
            Assertions.assertEquals((Object)uuid, (Object)commandId);
            return uuid;
        });
    }

    private PublishResponse publishExpectingSuccess(K key, Sequence readSequence, C command, NonEmptyList<E> expectedEvents, A expectedAggregate) {
        UUID commandId = this.publish(key, readSequence, command);
        NonEmptyList<Sequence> expectedSequences = this.validateEvents(key, readSequence, expectedEvents);
        AggregateUpdateResult updateResponse = this.testAPI.fetchAggregateUpdateResult(commandId).orElseGet(() -> (AggregateUpdateResult)Assertions.fail((String)"Didn't find command response"));
        Assertions.assertEquals((Object)commandId, (Object)updateResponse.commandId());
        Assertions.assertEquals((Object)readSequence, (Object)updateResponse.readSequence());
        AggregateUpdate aggregateUpdate = (AggregateUpdate)updateResponse.updatedAggregateResult().fold(reasons -> (AggregateUpdate)Assertions.fail((String)("Updating aggregate_update failed for command " + command + " failed with " + reasons)), Function.identity());
        Assertions.assertEquals((Object)expectedSequences.last(), (Object)aggregateUpdate.sequence());
        Assertions.assertEquals(expectedAggregate, (Object)aggregateUpdate.aggregate());
        KeyValue aggregateUpdatePair = this.testAPI.readAggregateTopic().orElseGet(() -> (KeyValue)Assertions.fail((String)"Missing update on aggregate_update topic"));
        Assertions.assertEquals(key, (Object)aggregateUpdatePair.key);
        Assertions.assertEquals((Object)expectedSequences.last(), (Object)((AggregateUpdate)aggregateUpdatePair.value).sequence());
        Assertions.assertEquals((Object)aggregateUpdate.aggregate(), (Object)((AggregateUpdate)aggregateUpdatePair.value).aggregate());
        Result queryByCommandId = this.testAPI.queryCommandResult(commandId, Duration.ofHours(1L)).unsafePerform(AggregateTestHelper::commandError);
        queryByCommandId.fold(reasons -> Assertions.fail((String)("Failed to fetch result with commandId " + reasons)), sequences -> {
            Assertions.assertEquals((Object)expectedSequences, (Object)sequences);
            return null;
        });
        return new PublishResponse(key, aggregateUpdate);
    }

    private void publishExpectingError(K key, Sequence readSequence, C command, Consumer<NonEmptyList<CommandError>> failureValidator) {
        UUID commandId = this.publish(key, readSequence, command);
        AggregateUpdateResult updateResponse = this.testAPI.fetchAggregateUpdateResult(commandId).orElseGet(() -> (AggregateUpdateResult)Assertions.fail((String)"Didn't find command response"));
        Assertions.assertEquals((Object)commandId, (Object)updateResponse.commandId());
        Assertions.assertEquals((Object)readSequence, (Object)updateResponse.readSequence());
        updateResponse.updatedAggregateResult().fold(reasons -> {
            failureValidator.accept((NonEmptyList<CommandError>)reasons);
            return null;
        }, aggregateUpdate -> Assertions.fail((String)("Expected update failure for command " + command + " but got update " + aggregateUpdate)));
        Assertions.assertEquals(Optional.empty(), this.testAPI.readEventTopic());
        Assertions.assertEquals(Optional.empty(), this.testAPI.readAggregateTopic());
        Result queryByCommandId = this.testAPI.queryCommandResult(commandId, Duration.ofHours(1L)).unsafePerform(AggregateTestHelper::commandError);
        queryByCommandId.fold(reasons -> {
            failureValidator.accept((NonEmptyList<CommandError>)reasons);
            return null;
        }, aggregateUpdate -> Assertions.fail((String)("Expected update failure for command " + command + " but got update " + aggregateUpdate)));
    }

    private NonEmptyList<Sequence> validateEvents(K key, Sequence readSequence, NonEmptyList<E> expectedEvents) {
        Sequence head = this.validEvent(key, new ValueWithSequence(expectedEvents.head(), readSequence.next()));
        ArrayList<Sequence> tail = new ArrayList<Sequence>();
        Sequence expectedWriteSequence = head.next();
        for (Object expectedEvent : expectedEvents.tail()) {
            tail.add(this.validEvent(key, new ValueWithSequence(expectedEvent, expectedWriteSequence)));
            expectedWriteSequence = expectedWriteSequence.next();
        }
        return new NonEmptyList((Object)head, tail);
    }

    private Sequence validEvent(K key, ValueWithSequence<E> expectedValue) {
        KeyValue eventPair = this.testAPI.readEventTopic().orElseGet(() -> (KeyValue)Assertions.fail((String)("Missing update on event topic. Expected " + expectedValue)));
        Assertions.assertEquals(key, (Object)eventPair.key);
        Assertions.assertEquals((Object)expectedValue.sequence(), (Object)((ValueWithSequence)eventPair.value).sequence());
        Assertions.assertEquals((Object)expectedValue.value(), (Object)((ValueWithSequence)eventPair.value).value());
        return expectedValue.sequence();
    }

    private static CommandError commandError(Exception e) {
        return CommandError.of((CommandError.Reason)CommandError.Reason.InternalError, (Throwable)e);
    }

    public final class PublishResponse {
        private final K key;
        private final AggregateUpdate<A> aggregateUpdate;

        PublishResponse(K key, AggregateUpdate<A> aggregateUpdate) {
            this.key = key;
            this.aggregateUpdate = aggregateUpdate;
        }

        public PublishBuilder thenPublish(C command) {
            return new PublishBuilder(this.key, this.aggregateUpdate.sequence(), command);
        }

        public PublishBuilder thenPublish(Function<AggregateUpdate<A>, ValueWithSequence<C>> commandGenerator) {
            ValueWithSequence commandWithSequence = commandGenerator.apply(this.aggregateUpdate);
            return new PublishBuilder(this.key, commandWithSequence.sequence(), commandWithSequence.value());
        }
    }

    public final class PublishBuilder {
        private final K key;
        private final Sequence readSequence;
        private final C command;

        PublishBuilder(K key, Sequence readSequence, C command) {
            this.key = key;
            this.readSequence = readSequence;
            this.command = command;
        }

        public PublishResponse expecting(NonEmptyList<E> expectedEvents, A expectedAggregate) {
            return AggregateTestHelper.this.publishExpectingSuccess(this.key, this.readSequence, this.command, expectedEvents, expectedAggregate);
        }

        public void expectingFailure(Consumer<NonEmptyList<CommandError>> failureValidator) {
            AggregateTestHelper.this.publishExpectingError(this.key, this.readSequence, this.command, failureValidator);
        }

        public void expectingFailure(NonEmptyList<CommandError.Reason> expectedErrorCodes) {
            Consumer<NonEmptyList<CommandError>> failureValidator = reasons -> Assertions.assertEquals((Object)expectedErrorCodes, (Object)reasons.map(CommandError::getReason));
            this.expectingFailure(failureValidator);
        }
    }
}

