/*
 * Decompiled with CFR 0.152.
 */
package com.ms.tools.api.tencent.factory;

import com.ms.tools.api.tencent.factory.TencentCloudApiConfig;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class ApiSignV3 {
    private static final Logger log = Logger.getLogger(ApiSignV3.class.getName());

    private static byte[] hmac256(byte[] key, String msg) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
        mac.init(secretKeySpec);
        return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
    }

    private static String sha256Hex(String s) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] d = md.digest(s.getBytes(StandardCharsets.UTF_8));
        return DatatypeConverter.printHexBinary((byte[])d).toLowerCase();
    }

    public static String signV3(String secretId, String secretKey, String timestamp, String payload) {
        try {
            String service = "sms";
            String host = TencentCloudApiConfig.Host.MAIN_SMS.getHost();
            String algorithm = "TC3-HMAC-SHA256";
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String date = sdf.format(new Date(Long.parseLong(timestamp + "000")));
            String httpRequestMethod = "POST";
            String canonicalUri = "/";
            String canonicalQueryString = "";
            String canonicalHeaders = "content-type:application/json; charset=utf-8\nhost:" + host + "\n";
            String signedHeaders = "content-type;host";
            String hashedRequestPayload = ApiSignV3.sha256Hex(payload);
            String canonicalRequest = "POST\n/\n\n" + canonicalHeaders + "\n" + "content-type;host" + "\n" + hashedRequestPayload;
            String credentialScope = date + "/" + "sms" + "/tc3_request";
            String hashedCanonicalRequest = ApiSignV3.sha256Hex(canonicalRequest);
            String stringToSign = "TC3-HMAC-SHA256\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
            byte[] secretDate = ApiSignV3.hmac256(("TC3" + secretKey).getBytes(StandardCharsets.UTF_8), date);
            byte[] secretService = ApiSignV3.hmac256(secretDate, "sms");
            byte[] secretSigning = ApiSignV3.hmac256(secretService, "tc3_request");
            String signature = DatatypeConverter.printHexBinary((byte[])ApiSignV3.hmac256(secretSigning, stringToSign)).toLowerCase();
            return "TC3-HMAC-SHA256 Credential=" + secretId + "/" + credentialScope + ", SignedHeaders=" + "content-type;host" + ", Signature=" + signature;
        }
        catch (Exception e) {
            log.warning(e.getMessage());
            return "";
        }
    }
}

