/*
 * Decompiled with CFR 0.152.
 */
package io.split.api.dtos.result;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ListResultDTO<T> {
    private List<T> objects;
    private Integer offset;
    private Integer limit;
    private Long totalCount;

    public ListResultDTO() {
        this.objects = new ArrayList<T>();
    }

    public ListResultDTO(Builder builder) {
        this.objects = builder.objects;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.totalCount = builder.totalCount;
    }

    @JsonProperty
    public List<T> objects() {
        return this.objects;
    }

    @JsonProperty
    public Integer offset() {
        return this.offset;
    }

    @JsonProperty
    public Integer limit() {
        return this.limit;
    }

    @JsonProperty
    public Long totalCount() {
        return this.totalCount;
    }

    public void setObjects(List<T> objects) {
        this.objects = objects;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListResultDTO that = (ListResultDTO)o;
        if (this.objects != null ? !this.objects.equals(that.objects) : that.objects != null) {
            return false;
        }
        if (this.offset != null ? !this.offset.equals(that.offset) : that.offset != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        return this.totalCount != null ? this.totalCount.equals(that.totalCount) : that.totalCount == null;
    }

    public int hashCode() {
        int result = this.objects != null ? this.objects.hashCode() : 0;
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.totalCount != null ? this.totalCount.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ListResultDTO{objects=" + this.objects + ", offset=" + this.offset + ", limit=" + this.limit + ", totalCount=" + this.totalCount + '}';
    }

    public static class Builder<T> {
        private Integer offset;
        private Integer limit;
        private Long totalCount;
        private List<T> objects;

        public Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder objects(List<T> objects) {
            this.objects = objects;
            return this;
        }

        Builder() {
            this.objects = new ArrayList<T>();
        }

        Builder(ListResultDTO prototype) {
            this.offset = prototype.offset;
            this.limit = prototype.limit;
            this.totalCount = prototype.totalCount;
            this.objects = prototype.objects;
        }

        public ListResultDTO<T> build() {
            return new ListResultDTO(this);
        }
    }
}

