/*
 * Decompiled with CFR 0.152.
 */
package io.typeflows.github.visualisation;

import io.typeflows.fs.MarkdownContent;
import io.typeflows.github.visualisation.UtilsKt;
import io.typeflows.github.workflow.Job;
import io.typeflows.github.workflow.Workflow;
import io.typeflows.github.workflow.trigger.WorkflowTrigger;
import io.typeflows.util.Builder;
import io.typeflows.visualisation.MermaidConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/typeflows/github/visualisation/SingleWorkflowLayout;", "Lio/typeflows/util/Builder;", "Lio/typeflows/fs/MarkdownContent;", "workflow", "Lio/typeflows/github/workflow/Workflow;", "<init>", "(Lio/typeflows/github/workflow/Workflow;)V", "build", "generateWorkflowLayoutDiagram", "", "typeflows-github"})
@SourceDebugExtension(value={"SMAP\nSingleWorkflowLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleWorkflowLayout.kt\nio/typeflows/github/visualisation/SingleWorkflowLayout\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1869#2,2:110\n1869#2,2:112\n1869#2:114\n1869#2,2:115\n1870#2:117\n774#2:118\n865#2,2:119\n1869#2:121\n1869#2,2:122\n1870#2:124\n1869#2,2:125\n*S KotlinDebug\n*F\n+ 1 SingleWorkflowLayout.kt\nio/typeflows/github/visualisation/SingleWorkflowLayout\n*L\n41#1:110,2\n65#1:112,2\n72#1:114\n75#1:115,2\n72#1:117\n86#1:118\n86#1:119,2\n89#1:121\n91#1:122,2\n89#1:124\n98#1:125,2\n*E\n"})
public final class SingleWorkflowLayout
implements Builder<MarkdownContent> {
    @NotNull
    private final Workflow workflow;

    public SingleWorkflowLayout(@NotNull Workflow workflow2) {
        Intrinsics.checkNotNullParameter((Object)((Object)workflow2), (String)"workflow");
        this.workflow = workflow2;
    }

    @NotNull
    public MarkdownContent build() {
        String workflowDiagram = this.generateWorkflowLayoutDiagram(this.workflow);
        return MarkdownContent.Companion.of((String)(((CharSequence)workflowDiagram).length() > 0 ? "```mermaid\n" + workflowDiagram + "\n```" : "*No jobs in this workflow*"));
    }

    /*
     * WARNING - void declaration
     */
    private final String generateWorkflowLayoutDiagram(Workflow workflow2) {
        List diagramLines;
        block11: {
            String triggerNodeId;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            String workflowNodeId;
            block12: {
                void $this$filterTo$iv$iv;
                Object jobNodeId;
                diagramLines = new ArrayList();
                diagramLines.addAll(MermaidConfig.INSTANCE.createFlowchartHeader());
                if (!((Collection)workflow2.on).isEmpty()) {
                    Iterable $this$forEach$iv2 = workflow2.on;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        WorkflowTrigger trigger = (WorkflowTrigger)((Object)element$iv);
                        boolean bl = false;
                        String triggerNodeId2 = UtilsKt.createEventNodeId((Object)trigger);
                        String triggerLabel = UtilsKt.createEventNodeLabel((Object)trigger);
                        diagramLines.add("    " + triggerNodeId2 + "([\"" + triggerLabel + "\"])");
                    }
                }
                if (workflow2.jobs.isEmpty()) {
                    return !((Collection)workflow2.on).isEmpty() ? CollectionsKt.joinToString$default((Iterable)diagramLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) : "";
                }
                workflowNodeId = UtilsKt.sanitizeNodeId(workflow2.getName());
                diagramLines.add("    subgraph " + workflowNodeId + "[\"" + UtilsKt.escapeMermaid(workflow2.safeName()) + "\"]");
                String string = UtilsKt.getWorkflowMetadata(workflow2);
                if (string != null) {
                    Iterator metadataLabel = string;
                    boolean bl = false;
                    String metadataNodeId = workflowNodeId + "_metadata";
                    diagramLines.add("        " + metadataNodeId + "[[\"" + (String)((Object)metadataLabel) + "\"]]");
                }
                Iterable $this$forEach$iv3 = workflow2.jobs;
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv3) {
                    Job job = (Job)((Object)element$iv);
                    boolean bl = false;
                    jobNodeId = workflowNodeId + "_" + UtilsKt.sanitizeNodeId(job.id);
                    String jobLabel = UtilsKt.buildJobNodeLabel(job);
                    diagramLines.add("        " + (String)jobNodeId + "[\"" + jobLabel + "\"]");
                }
                $this$forEach$iv3 = workflow2.jobs;
                $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv3) {
                    Job job = (Job)((Object)element$iv);
                    boolean bl = false;
                    if (!(!((Collection)job.needs).isEmpty())) continue;
                    jobNodeId = workflowNodeId + "_" + UtilsKt.sanitizeNodeId(job.id);
                    Iterable $this$forEach$iv4 = job.needs;
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv2 : $this$forEach$iv4) {
                        Job dependency = (Job)((Object)element$iv2);
                        boolean bl2 = false;
                        String dependencyNodeId = workflowNodeId + "_" + UtilsKt.sanitizeNodeId(dependency.id);
                        diagramLines.add("        " + dependencyNodeId + " --> " + (String)jobNodeId);
                    }
                }
                diagramLines.add("    end");
                if (!(!((Collection)workflow2.on).isEmpty())) break block11;
                Iterable $this$filter$iv = workflow2.jobs;
                boolean $i$f$filter = false;
                Iterable element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Job it = (Job)((Object)element$iv$iv);
                    boolean bl = false;
                    if (!it.needs.isEmpty()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List firstJobs = (List)destination$iv$iv;
                if (!(!((Collection)firstJobs).isEmpty())) break block12;
                $this$forEach$iv = workflow2.on;
                $i$f$forEach = false;
                for (Object element$iv3 : $this$forEach$iv) {
                    WorkflowTrigger trigger = (WorkflowTrigger)((Object)element$iv3);
                    boolean bl = false;
                    triggerNodeId = UtilsKt.createEventNodeId((Object)trigger);
                    Iterable $this$forEach$iv5 = firstJobs;
                    boolean $i$f$forEach5 = false;
                    for (Object element$iv4 : $this$forEach$iv5) {
                        Job job = (Job)((Object)element$iv4);
                        boolean bl3 = false;
                        String jobNodeId2 = workflowNodeId + "_" + UtilsKt.sanitizeNodeId(job.id);
                        diagramLines.add("    " + triggerNodeId + " --> " + jobNodeId2);
                    }
                }
                break block11;
            }
            if (workflow2.jobs.size() != 1) break block11;
            $this$forEach$iv = workflow2.on;
            $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                WorkflowTrigger trigger = (WorkflowTrigger)((Object)element$iv3);
                boolean bl = false;
                triggerNodeId = UtilsKt.createEventNodeId((Object)trigger);
                String jobNodeId = workflowNodeId + "_" + UtilsKt.sanitizeNodeId(((Job)((Object)CollectionsKt.first(workflow2.jobs))).id);
                diagramLines.add("    " + triggerNodeId + " --> " + jobNodeId);
            }
        }
        return CollectionsKt.joinToString$default((Iterable)diagramLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }
}

