/*
 * Decompiled with CFR 0.152.
 */
package io.typeflows.github.visualisation;

import io.typeflows.github.workflow.Container;
import io.typeflows.github.workflow.Cron;
import io.typeflows.github.workflow.Defaults;
import io.typeflows.github.workflow.Expression;
import io.typeflows.github.workflow.Input;
import io.typeflows.github.workflow.Job;
import io.typeflows.github.workflow.Output;
import io.typeflows.github.workflow.Permissions;
import io.typeflows.github.workflow.PullRequestType;
import io.typeflows.github.workflow.RunsOn;
import io.typeflows.github.workflow.Strategy;
import io.typeflows.github.workflow.Tag;
import io.typeflows.github.workflow.Workflow;
import io.typeflows.github.workflow.trigger.Branches;
import io.typeflows.github.workflow.trigger.Paths;
import io.typeflows.github.workflow.trigger.PullRequest;
import io.typeflows.github.workflow.trigger.Push;
import io.typeflows.github.workflow.trigger.RepositoryDispatch;
import io.typeflows.github.workflow.trigger.Schedule;
import io.typeflows.github.workflow.trigger.WorkflowCall;
import io.typeflows.github.workflow.trigger.WorkflowDispatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001\u001a\u0017\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001\u001a\u000e\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010 \u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006!"}, d2={"escapeMermaid", "", "getRunnerIcon", "runsOn", "Lio/typeflows/github/workflow/RunsOn;", "getRunnerLabel", "formatJobCondition", "condition", "formatTimeout", "minutes", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "formatContainer", "job", "Lio/typeflows/github/workflow/Job;", "buildJobNodeLabel", "getJobNodeShape", "getTriggerDisplayName", "trigger", "", "getTriggerIcon", "getTriggerDetails", "getWorkflowMetadata", "workflow", "Lio/typeflows/github/workflow/Workflow;", "getJobOutputs", "getMatrixInfo", "hasSecrets", "", "sanitizeNodeId", "name", "createEventNodeLabel", "createEventNodeId", "typeflows-github"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\nio/typeflows/github/visualisation/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,283:1\n1#2:284\n774#3:285\n865#3,2:286\n774#3:288\n865#3,2:289\n1563#3:291\n1634#3,3:292\n1803#3,3:295\n188#4,3:298\n434#5:301\n507#5,5:302\n*S KotlinDebug\n*F\n+ 1 utils.kt\nio/typeflows/github/visualisation/UtilsKt\n*L\n136#1:285\n136#1:286,2\n137#1:288\n137#1:289,2\n157#1:291\n157#1:292,3\n255#1:295,3\n263#1:298,3\n268#1:301\n268#1:302,5\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final String escapeMermaid(@NotNull String $this$escapeMermaid) {
        Intrinsics.checkNotNullParameter((Object)$this$escapeMermaid, (String)"<this>");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$escapeMermaid, (String)"/", (String)"\\/", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"[", (String)"(", (boolean)false, (int)4, null), (String)"]", (String)")", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getRunnerIcon(@NotNull RunsOn runsOn) {
        Intrinsics.checkNotNullParameter((Object)runsOn, (String)"runsOn");
        String string = runsOn.render().toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String runnerString = string;
        return StringsKt.contains$default((CharSequence)runnerString, (CharSequence)"ubuntu", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)runnerString, (CharSequence)"linux", (boolean)false, (int)2, null) ? "\ud83d\udc27" : (StringsKt.contains$default((CharSequence)runnerString, (CharSequence)"windows", (boolean)false, (int)2, null) ? "\ud83e\ude9f" : (StringsKt.contains$default((CharSequence)runnerString, (CharSequence)"macos", (boolean)false, (int)2, null) ? "\ud83c\udf4e" : (StringsKt.contains$default((CharSequence)runnerString, (CharSequence)"self-hosted", (boolean)false, (int)2, null) ? "\ud83c\udfe0" : "\ud83d\udcbb")));
    }

    @NotNull
    public static final String getRunnerLabel(@NotNull RunsOn runsOn) {
        Object object;
        Object rendered;
        Intrinsics.checkNotNullParameter((Object)runsOn, (String)"runsOn");
        Object object2 = rendered = runsOn.render();
        if (object2 instanceof String) {
            object = (String)rendered;
        } else if (object2 instanceof List) {
            object = CollectionsKt.joinToString$default((Iterable)((Iterable)rendered), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        } else if (object2 instanceof Map) {
            Object group = ((Map)rendered).get("group");
            Object labels = ((Map)rendered).get("labels");
            if (group != null && labels != null) {
                object = group + ": " + labels;
            } else {
                Object v = group;
                object = v != null ? v.toString() : rendered.toString();
            }
        } else {
            object = rendered.toString();
        }
        return object;
    }

    @Nullable
    public static final String formatJobCondition(@Nullable String condition) {
        String string;
        String string2 = condition;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = "\ud83d\udd10 if: " + UtilsKt.escapeMermaid(it);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String formatTimeout(@Nullable Integer minutes) {
        String string;
        Integer n = minutes;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            string = "\u23f1\ufe0f " + it + "m timeout";
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String formatContainer(@NotNull Job job) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)job), (String)"job");
        Container container = job.container;
        if (container != null) {
            Container it = container;
            boolean bl = false;
            string = "\ud83d\udce6 container: " + UtilsKt.escapeMermaid(it.image);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String buildJobNodeLabel(@NotNull Job job) {
        String it;
        Intrinsics.checkNotNullParameter((Object)((Object)job), (String)"job");
        List lines = new ArrayList();
        String string = job.name;
        if (string == null) {
            string = job.id;
        }
        lines.add(UtilsKt.escapeMermaid(string));
        String runnerIcon = UtilsKt.getRunnerIcon(job.runsOn);
        String runnerLabel = UtilsKt.escapeMermaid(UtilsKt.getRunnerLabel(job.runsOn));
        lines.add(runnerIcon + " " + runnerLabel);
        String string2 = UtilsKt.formatTimeout(job.timeoutMinutes);
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            lines.add(it);
        }
        Expression expression = job.condition;
        String string3 = UtilsKt.formatJobCondition(expression != null ? expression.getValue() : null);
        if (string3 != null) {
            it = string3;
            boolean bl = false;
            lines.add(it);
        }
        String string4 = UtilsKt.formatContainer(job);
        if (string4 != null) {
            it = string4;
            boolean bl = false;
            lines.add(it);
        }
        String string5 = UtilsKt.getMatrixInfo(job);
        if (string5 != null) {
            it = string5;
            boolean bl = false;
            lines.add(it);
        }
        String string6 = UtilsKt.getJobOutputs(job);
        if (string6 != null) {
            it = string6;
            boolean bl = false;
            lines.add(it);
        }
        if (UtilsKt.hasSecrets(job)) {
            lines.add("\ud83d\udd11 Uses secrets");
        }
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"<br/>", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String getJobNodeShape(@NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)((Object)job), (String)"job");
        String string = job.name;
        if (string == null) {
            string = job.id;
        }
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String jobName = string2;
        return StringsKt.contains$default((CharSequence)jobName, (CharSequence)"deploy", (boolean)false, (int)2, null) ? "stadium" : (job.condition != null ? "diamond" : (job.strategy != null ? "hexagon" : "rectangle"));
    }

    @NotNull
    public static final String getTriggerDisplayName(@NotNull Object trigger) {
        String className;
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        String string = Reflection.getOrCreateKotlinClass(trigger.getClass()).getSimpleName();
        if (string == null) {
            string = trigger.toString();
        }
        return switch (className = string) {
            case "Push" -> "push";
            case "WorkflowDispatch" -> "workflow_dispatch";
            case "PullRequest" -> "pull_request";
            case "RepositoryDispatch" -> "repository_dispatch";
            case "Schedule" -> "schedule";
            case "Release" -> "release";
            case "WorkflowCall" -> "workflow_call";
            default -> {
                String v2 = className.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
                yield StringsKt.replace$default((String)v2, (String)"trigger", (String)"", (boolean)false, (int)4, null);
            }
        };
    }

    @NotNull
    public static final String getTriggerIcon(@NotNull Object trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        String string = Reflection.getOrCreateKotlinClass(trigger.getClass()).getSimpleName();
        if (string == null) {
            string = trigger.toString();
        }
        return switch (string) {
            case "Push" -> "\ud83d\udce4";
            case "WorkflowDispatch" -> "\ud83d\udc64";
            case "PullRequest" -> "\ud83d\udd00";
            case "RepositoryDispatch" -> "\ud83d\udd14";
            case "Schedule" -> "\u23f0";
            case "Release" -> "\ud83c\udff7\ufe0f";
            case "WorkflowCall" -> "\ud83d\udd17";
            default -> "\ud83d\udd14";
        };
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getTriggerDetails(@NotNull Object trigger) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Object object2 = trigger;
        if (object2 instanceof Schedule) {
            List<Cron> list;
            List<Cron> it = list = ((Schedule)((Object)trigger)).cron;
            boolean bl = false;
            List<Cron> list2 = !((Collection)it).isEmpty() ? list : null;
            if (list2 != null) {
                List<Cron> crons = list2;
                boolean bl2 = false;
                object = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)crons, (int)2), (CharSequence)", ", null, null, (int)0, null, UtilsKt::getTriggerDetails$lambda$1$0, (int)30, null) + (crons.size() > 2 ? "..." : "");
            } else {
                object = null;
            }
        } else if (object2 instanceof Push) {
            List ignoredTags;
            Object it;
            List details = new ArrayList();
            Branches branches = ((Push)((Object)trigger)).branches;
            if (branches != null) {
                it = branches;
                boolean bl = false;
                details.add("branches(" + (it.include() ? "only" : "ignore") + ": " + it.getGlobs().size() + ")");
            }
            Paths paths = ((Push)((Object)trigger)).paths;
            if (paths != null) {
                it = paths;
                boolean bl = false;
                details.add("paths(" + (it.include() ? "only" : "ignore") + ": " + it.getGlobs().size() + ")");
            }
            if (!((Collection)((Push)((Object)trigger)).tags).isEmpty()) {
                void $this$filterTo$iv$iv;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv = ((Push)((Object)trigger)).tags;
                boolean $i$f$filter = false;
                Iterable bl = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    Tag it2 = (Tag)((Object)element$iv$iv);
                    boolean bl3 = false;
                    if (!(!it2.isIgnored())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List includedTags = (List)destination$iv$iv;
                Iterable $this$filter$iv2 = ((Push)((Object)trigger)).tags;
                boolean $i$f$filter2 = false;
                destination$iv$iv = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Tag it3 = (Tag)((Object)element$iv$iv);
                    boolean bl4 = false;
                    if (!it3.isIgnored()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                ignoredTags = (List)destination$iv$iv2;
                List tagDetails = new ArrayList();
                if (!((Collection)includedTags).isEmpty()) {
                    tagDetails.add("tags(only: " + includedTags.size() + ")");
                }
                if (!((Collection)ignoredTags).isEmpty()) {
                    tagDetails.add("tags(ignore: " + ignoredTags.size() + ")");
                }
                details.addAll(tagDetails);
            }
            ignoredTags = details;
            it = ignoredTags;
            boolean bl = false;
            List list = !((Collection)it).isEmpty() ? ignoredTags : null;
            object = list != null ? CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : null;
        } else if (object2 instanceof PullRequest) {
            Object object3;
            List details = new ArrayList();
            if (!((Collection)((PullRequest)((Object)trigger)).types).isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = CollectionsKt.take((Iterable)((PullRequest)((Object)trigger)).types, (int)3);
                boolean $i$f$map = false;
                Iterable $this$filterTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    PullRequestType it3 = (PullRequestType)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it3.name().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    collection.add(string);
                }
                List typeNames = (List)destination$iv$iv;
                String suffix = ((PullRequest)((Object)trigger)).types.size() > 3 ? "..." : "";
                object3 = "(" + CollectionsKt.joinToString$default((Iterable)typeNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + suffix + ")";
            } else {
                object3 = "(*)";
            }
            String typesDescription = object3;
            details.add(typesDescription);
            Branches branches = ((PullRequest)((Object)trigger)).branches;
            if (branches != null) {
                Branches it = branches;
                boolean bl = false;
                details.add("branches(" + (it.include() ? "only" : "ignore") + ": " + it.getGlobs().size() + ")");
            }
            Paths paths = ((PullRequest)((Object)trigger)).paths;
            if (paths != null) {
                Paths it = paths;
                boolean bl = false;
                details.add("paths(" + (it.include() ? "only" : "ignore") + ": " + it.getGlobs().size() + ")");
            }
            object = CollectionsKt.joinToString$default((Iterable)details, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        } else if (object2 instanceof WorkflowDispatch) {
            List<Input<?>> typesDescription;
            List<Input<?>> it = typesDescription = ((WorkflowDispatch)((Object)trigger)).inputs;
            boolean bl = false;
            List<Input<Object>> list = !((Collection)it).isEmpty() ? typesDescription : null;
            if (list != null) {
                List<Input<?>> inputs = list;
                boolean bl5 = false;
                String inputNames = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)inputs, (int)3), (CharSequence)", ", null, null, (int)0, null, UtilsKt::getTriggerDetails$lambda$11$0, (int)30, null);
                String suffix = inputs.size() > 3 ? "..." : "";
                object = "inputs: " + inputNames + suffix;
            } else {
                object = null;
            }
        } else if (object2 instanceof WorkflowCall) {
            List list;
            String suffix;
            List details = new ArrayList();
            if (!((Collection)((WorkflowCall)((Object)trigger)).inputs).isEmpty()) {
                String inputNames = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)((WorkflowCall)((Object)trigger)).inputs, (int)2), (CharSequence)", ", null, null, (int)0, null, UtilsKt::getTriggerDetails$lambda$12, (int)30, null);
                suffix = ((WorkflowCall)((Object)trigger)).inputs.size() > 2 ? "..." : "";
                details.add("inputs: " + inputNames + suffix);
            }
            if (!((Collection)((WorkflowCall)((Object)trigger)).outputs).isEmpty()) {
                String outputNames = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)((WorkflowCall)((Object)trigger)).outputs, (int)2), (CharSequence)", ", null, null, (int)0, null, UtilsKt::getTriggerDetails$lambda$13, (int)30, null);
                suffix = ((WorkflowCall)((Object)trigger)).outputs.size() > 2 ? "..." : "";
                details.add("outputs: " + outputNames + suffix);
            }
            if (((WorkflowCall)((Object)trigger)).secrets != null) {
                details.add("secrets");
            }
            List it = list = details;
            boolean bl = false;
            List list3 = !((Collection)it).isEmpty() ? list : null;
            object = list3 != null ? CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : null;
        } else {
            object = object2 instanceof RepositoryDispatch ? (((RepositoryDispatch)((Object)trigger)).types.isEmpty() ? "(*)" : "(" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)((RepositoryDispatch)((Object)trigger)).types, (int)3), (CharSequence)", ", null, null, (int)0, null, UtilsKt::getTriggerDetails$lambda$15, (int)30, null) + (((RepositoryDispatch)((Object)trigger)).types.size() > 3 ? "..." : "") + ")") : null;
        }
        return object;
    }

    @Nullable
    public static final String getWorkflowMetadata(@NotNull Workflow workflow2) {
        List metadata;
        block4: {
            Object it;
            Intrinsics.checkNotNullParameter((Object)((Object)workflow2), (String)"workflow");
            metadata = new ArrayList();
            String string = workflow2.description;
            if (string != null) {
                it = string;
                boolean bl = false;
                metadata.add("\ud83d\udcdd " + UtilsKt.escapeMermaid((String)it));
            }
            Permissions permissions = workflow2.permissions;
            if (permissions != null) {
                it = permissions;
                boolean bl = false;
                Object rendered = it.render();
                String permStr = rendered instanceof String ? (String)rendered : (rendered instanceof Map ? "custom permissions" : "permissions set");
                metadata.add("\ud83d\udd10 " + permStr);
            }
            String string2 = workflow2.concurrency;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                metadata.add("\ud83d\udd04 concurrency: " + (String)it);
            }
            if (!workflow2.env.isEmpty()) {
                int count;
                metadata.add("\ud83c\udf0d " + count + " env var" + ((count = workflow2.env.size()) == 1 ? "" : "s"));
            }
            Defaults defaults = workflow2.defaults;
            if (defaults == null) break block4;
            it = defaults;
            boolean bl = false;
            metadata.add("\u2699\ufe0f defaults set");
        }
        return !((Collection)metadata).isEmpty() ? "\ud83d\udd27 Workflow Config<br/>" + CollectionsKt.joinToString$default((Iterable)metadata, (CharSequence)"<br/>", null, null, (int)0, null, null, (int)62, null) : null;
    }

    @Nullable
    public static final String getJobOutputs(@NotNull Job job) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)job), (String)"job");
        if (!((Collection)job.outputs).isEmpty()) {
            String outputNames = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)job.outputs, (int)3), (CharSequence)", ", null, null, (int)0, null, UtilsKt::getJobOutputs$lambda$0, (int)30, null);
            String suffix = job.outputs.size() > 3 ? "..." : "";
            string = "\ud83d\udce4 Outputs: " + outputNames + suffix;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getMatrixInfo(@NotNull Job job) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)job), (String)"job");
        Strategy strategy = job.strategy;
        if (strategy != null) {
            void $this$fold$iv;
            Strategy strategy2 = strategy;
            boolean bl = false;
            Iterable iterable = strategy2.matrix.values();
            int initial$iv = 1;
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void values;
                List list = (List)element$iv;
                int acc = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = acc * values.size();
            }
            int matrixSize = accumulator$iv;
            String dimensions = CollectionsKt.joinToString$default((Iterable)strategy2.matrix.keySet(), (CharSequence)"\u00d7", null, null, (int)0, null, UtilsKt::getMatrixInfo$lambda$0$1, (int)30, null);
            string = "\ud83d\udcca Matrix: " + dimensions + " (" + matrixSize + " runs)";
        } else {
            string = null;
        }
        return string;
    }

    public static final boolean hasSecrets(@NotNull Job job) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)job), (String)"job");
            Map<String, Object> $this$any$iv = job.env;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator<Map.Entry<String, Object>> iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> element$iv;
                    Map.Entry<String, Object> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Object value = entry.getValue();
                    if (!(StringsKt.contains$default((CharSequence)value.toString(), (CharSequence)"secrets.", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)value.toString(), (CharSequence)"${{ secrets.", (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeNodeId(@NotNull String name) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String $this$filter$iv = name;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isLetterOrDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    @NotNull
    public static final String createEventNodeLabel(@NotNull Object trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        String triggerName = UtilsKt.getTriggerDisplayName(trigger);
        String icon = UtilsKt.getTriggerIcon(trigger);
        String details = UtilsKt.getTriggerDetails(trigger);
        return details != null ? icon + " " + UtilsKt.escapeMermaid(triggerName) + "<br/>" + UtilsKt.escapeMermaid(details) : icon + " " + UtilsKt.escapeMermaid(triggerName);
    }

    @NotNull
    public static final String createEventNodeId(@NotNull Object trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        return UtilsKt.sanitizeNodeId(UtilsKt.getTriggerDisplayName(trigger));
    }

    private static final CharSequence getTriggerDetails$lambda$1$0(Cron it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return UtilsKt.escapeMermaid((String)it.getValue());
    }

    private static final CharSequence getTriggerDetails$lambda$11$0(Input it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence getTriggerDetails$lambda$12(Input it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence getTriggerDetails$lambda$13(Output it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final CharSequence getTriggerDetails$lambda$15(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilsKt.escapeMermaid(it);
    }

    private static final CharSequence getJobOutputs$lambda$0(Output it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilsKt.escapeMermaid(it.getName());
    }

    private static final CharSequence getMatrixInfo$lambda$0$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilsKt.escapeMermaid(it);
    }
}

