/*
 * Decompiled with CFR 0.152.
 */
package io.typeflows.github.visualisation;

import io.typeflows.fs.DirectoryCollector;
import io.typeflows.fs.MarkdownContent;
import io.typeflows.github.visualisation.UtilsKt;
import io.typeflows.github.workflow.GitHub;
import io.typeflows.github.workflow.Job;
import io.typeflows.github.workflow.Workflow;
import io.typeflows.github.workflow.step.SendRepositoryDispatch;
import io.typeflows.github.workflow.step.Step;
import io.typeflows.github.workflow.trigger.RepositoryDispatch;
import io.typeflows.github.workflow.trigger.WorkflowTrigger;
import io.typeflows.util.Builder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/typeflows/github/visualisation/WorkflowTriggersFlowchart;", "Lio/typeflows/util/Builder;", "Lio/typeflows/fs/MarkdownContent;", "workflows", "Lio/typeflows/fs/DirectoryCollector;", "Lio/typeflows/github/workflow/Workflow;", "<init>", "(Lio/typeflows/fs/DirectoryCollector;)V", "build", "generateFlowchartDiagram", "", "typeflows-github"})
@SourceDebugExtension(value={"SMAP\nWorkflowTriggersFlowchart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkflowTriggersFlowchart.kt\nio/typeflows/github/visualisation/WorkflowTriggersFlowchart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,200:1\n1869#2:201\n1869#2:202\n1869#2:210\n1870#2:218\n1870#2:219\n1869#2:220\n1869#2:221\n1870#2:229\n1870#2:230\n1870#2:231\n1563#2:232\n1634#2,3:233\n1869#2,2:236\n1491#2:238\n1516#2,3:239\n1519#2,3:249\n1869#2,2:254\n1869#2,2:257\n1869#2:261\n1869#2,2:262\n1761#2,3:264\n1869#2,2:267\n1870#2:269\n1869#2:271\n1869#2,2:272\n1870#2:274\n382#3,7:203\n382#3,7:211\n382#3,7:222\n382#3,7:242\n216#4,2:252\n216#4:256\n217#4:259\n216#4:260\n217#4:270\n*S KotlinDebug\n*F\n+ 1 WorkflowTriggersFlowchart.kt\nio/typeflows/github/visualisation/WorkflowTriggersFlowchart\n*L\n40#1:201\n41#1:202\n56#1:210\n56#1:218\n41#1:219\n62#1:220\n63#1:221\n63#1:229\n62#1:230\n40#1:231\n78#1:232\n78#1:233,3\n81#1:236,2\n98#1:238\n98#1:239,3\n98#1:249,3\n116#1:254,2\n126#1:257,2\n141#1:261\n145#1:262,2\n156#1:264,3\n161#1:267,2\n141#1:269\n181#1:271\n187#1:272,2\n181#1:274\n43#1:203,7\n57#1:211,7\n67#1:222,7\n98#1:242,7\n102#1:252,2\n121#1:256\n121#1:259\n138#1:260\n138#1:270\n*E\n"})
public final class WorkflowTriggersFlowchart
implements Builder<MarkdownContent> {
    @NotNull
    private final DirectoryCollector<Workflow> workflows;

    public WorkflowTriggersFlowchart(@NotNull DirectoryCollector<Workflow> workflows) {
        Intrinsics.checkNotNullParameter(workflows, (String)"workflows");
        this.workflows = workflows;
    }

    @NotNull
    public MarkdownContent build() {
        return MarkdownContent.Companion.of("```mermaid\n" + this.generateFlowchartDiagram() + "\n```");
    }

    /*
     * WARNING - void declaration
     */
    private final String generateFlowchartDiagram() {
        Map.Entry element$iv;
        Iterator $this$groupByTo$iv$iv;
        Object trigger;
        void $this$mapTo$iv$iv;
        Object eventTypes;
        Object workflow2;
        Map eventToWorkflows = new LinkedHashMap();
        Map workflowTriggerDetails = new LinkedHashMap();
        Map triggersByEvent = new LinkedHashMap();
        Map repositoryDispatchSenders = new LinkedHashMap();
        Map repositoryDispatchReceivers = new LinkedHashMap();
        Map repositoryDispatchTargets = new LinkedHashMap();
        Set connections = new LinkedHashSet();
        Iterable $this$forEach$iv = (Iterable)this.workflows;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            workflow2 = (Workflow)((Object)element$iv2);
            boolean bl = false;
            Iterable $this$forEach$iv2 = workflow2.on;
            boolean $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                String details;
                Object object;
                void $this$getOrPut$iv;
                WorkflowTrigger trigger2 = (WorkflowTrigger)((Object)element$iv3);
                boolean bl2 = false;
                String eventName = trigger2.getOn();
                Map map = eventToWorkflows;
                String key$iv = eventName;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(workflow2.getName());
                if (!triggersByEvent.containsKey(eventName)) {
                    triggersByEvent.put(eventName, trigger2);
                }
                if ((details = UtilsKt.getTriggerDetails((Object)trigger2)) != null) {
                    workflowTriggerDetails.put(new Pair((Object)workflow2.getName(), (Object)eventName), details);
                }
                if (!(trigger2 instanceof RepositoryDispatch)) continue;
                eventTypes = ((RepositoryDispatch)trigger2).types.isEmpty() ? CollectionsKt.listOf((Object)"*") : ((RepositoryDispatch)trigger2).types;
                Iterable $this$forEach$iv3 = (Iterable)eventTypes;
                boolean $i$f$forEach3 = false;
                for (Object element$iv4 : $this$forEach$iv3) {
                    Object object2;
                    void $this$getOrPut$iv2;
                    String eventType = (String)element$iv4;
                    boolean bl4 = false;
                    Map map2 = repositoryDispatchReceivers;
                    String key$iv2 = eventType;
                    boolean $i$f$getOrPut2 = false;
                    Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                    if (value$iv2 == null) {
                        boolean bl5 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(key$iv2, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv2;
                    }
                    ((List)object2).add(workflow2.getName());
                }
            }
            $this$forEach$iv2 = workflow2.jobs;
            $i$f$forEach2 = false;
            for (Object element$iv3 : $this$forEach$iv2) {
                Job job = (Job)((Object)element$iv3);
                boolean bl6 = false;
                Iterable $this$forEach$iv4 = job.steps;
                boolean $i$f$forEach4 = false;
                for (Object element$iv5 : $this$forEach$iv4) {
                    Object object;
                    void $this$getOrPut$iv;
                    Step step = (Step)((Object)element$iv5);
                    boolean bl7 = false;
                    if (!(step instanceof SendRepositoryDispatch)) continue;
                    String string = ((SendRepositoryDispatch)step).repository;
                    if (string == null) {
                        string = GitHub.repository.getValue();
                    }
                    String targetRepo = string;
                    String dispatchKey = ((SendRepositoryDispatch)step).getEventType() + "@" + targetRepo;
                    Map bl4 = repositoryDispatchSenders;
                    String key$iv = dispatchKey;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl8 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((List)object).add(workflow2.getName());
                    repositoryDispatchTargets.put(dispatchKey, targetRepo);
                }
            }
        }
        List diagramLines = new ArrayList();
        diagramLines.add("flowchart LR");
        Iterable $this$map$iv = repositoryDispatchSenders.keySet();
        boolean $i$f$map = false;
        workflow2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv3;
            element$iv3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] bl6 = new String[]{"@"};
            collection.add((String)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])bl6, (boolean)false, (int)0, (int)6, null).get(0));
        }
        Set allRepositoryDispatchEventTypes = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (Iterable)repositoryDispatchReceivers.keySet());
        Set processedNodes = new LinkedHashSet();
        Iterable $this$forEach$iv5 = eventToWorkflows.keySet();
        boolean $i$f$forEach5 = false;
        for (Object element$iv6 : $this$forEach$iv5) {
            String string;
            String event = (String)element$iv6;
            boolean bl = false;
            trigger = triggersByEvent.get(event);
            if (trigger instanceof RepositoryDispatch) continue;
            String nodeId = UtilsKt.sanitizeNodeId(event);
            if (trigger != null) {
                String icon = UtilsKt.getTriggerIcon(trigger);
                String triggerName = UtilsKt.getTriggerDisplayName(trigger);
                string = icon + " " + UtilsKt.escapeMermaid(triggerName);
            } else {
                string = "\u26a1 " + event;
            }
            String label2 = string;
            diagramLines.add("    " + nodeId + "([\"" + label2 + "\"])");
        }
        Iterable $this$groupBy$iv = repositoryDispatchSenders.keySet();
        boolean $i$f$groupBy = false;
        Iterable element$iv6 = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        trigger = $this$groupByTo$iv$iv.iterator();
        while (trigger.hasNext()) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Object element$iv$iv = trigger.next();
            String dispatchKey = (String)element$iv$iv;
            boolean bl10 = false;
            String string = (String)repositoryDispatchTargets.get(dispatchKey);
            if (string == null) {
                string = "";
            }
            String key$iv$iv = string;
            eventTypes = destination$iv$iv2;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl9 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map repositoryDispatchesByRepo = destination$iv$iv2;
        Object $this$forEach$iv6 = repositoryDispatchesByRepo;
        boolean $i$f$forEach6 = false;
        $this$groupByTo$iv$iv = $this$forEach$iv6.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            String nodeId;
            String repoDisplay;
            Map.Entry $i$f$groupByTo2 = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            String targetRepo = (String)$i$f$groupByTo2.getKey();
            List dispatchKeys = (List)$i$f$groupByTo2.getValue();
            if (Intrinsics.areEqual((Object)targetRepo, (Object)GitHub.repository.getValue())) {
                v7 = "this repo";
            } else if (StringsKt.contains$default((CharSequence)targetRepo, (CharSequence)"/", (boolean)false, (int)2, null)) {
                String[] bl10 = new String[]{"/"};
                v7 = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)targetRepo, (String[])bl10, (boolean)false, (int)0, (int)6, null));
            } else {
                v7 = repoDisplay = targetRepo;
            }
            if (processedNodes.contains(nodeId = UtilsKt.sanitizeNodeId("repository_dispatch_" + targetRepo))) continue;
            String label3 = "\ud83d\udd14 repository_dispatch<br/>\u2192 " + UtilsKt.escapeMermaid(repoDisplay);
            diagramLines.add("    " + nodeId + "([\"" + label3 + "\"])");
            processedNodes.add(nodeId);
        }
        $this$forEach$iv6 = (Iterable)this.workflows;
        $i$f$forEach6 = false;
        $this$groupByTo$iv$iv = $this$forEach$iv6.iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            element$iv = $this$groupByTo$iv$iv.next();
            Workflow workflow3 = (Workflow)((Object)element$iv);
            boolean bl = false;
            diagramLines.add("    " + UtilsKt.sanitizeNodeId(workflow3.getName()) + "[\"" + UtilsKt.escapeMermaid(workflow3.safeName()) + "\"]");
        }
        $this$forEach$iv6 = eventToWorkflows;
        $i$f$forEach6 = false;
        $this$groupByTo$iv$iv = $this$forEach$iv6.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Map.Entry entry = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            String event = (String)entry.getKey();
            List workflowNames = (List)entry.getValue();
            Object trigger3 = triggersByEvent.get(event);
            if (trigger3 instanceof RepositoryDispatch) continue;
            String eventNodeId = UtilsKt.sanitizeNodeId(event);
            Iterable $this$forEach$iv7 = workflowNames;
            boolean $i$f$forEach7 = false;
            for (Object element$iv7 : $this$forEach$iv7) {
                String workflowName = (String)element$iv7;
                boolean bl11 = false;
                String details = (String)workflowTriggerDetails.get(new Pair((Object)workflowName, (Object)event));
                String connection = details != null ? "    " + eventNodeId + " -->|\"" + UtilsKt.escapeMermaid(details) + "\"|" + UtilsKt.sanitizeNodeId(workflowName) : "    " + eventNodeId + " --> " + UtilsKt.sanitizeNodeId(workflowName);
                connections.add(connection);
            }
        }
        $this$forEach$iv6 = repositoryDispatchesByRepo;
        $i$f$forEach6 = false;
        $this$groupByTo$iv$iv = $this$forEach$iv6.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Map.Entry entry = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            String targetRepo = (String)entry.getKey();
            List dispatchKeys = (List)entry.getValue();
            String dispatchNodeId = UtilsKt.sanitizeNodeId("repository_dispatch_" + targetRepo);
            Iterable $this$forEach$iv8 = dispatchKeys;
            boolean $i$f$forEach8 = false;
            for (Object element$iv8 : $this$forEach$iv8) {
                Object object;
                List wildcardReceivers;
                List receivers;
                List list;
                List specificReceivers;
                String dispatchKey = (String)element$iv8;
                boolean bl12 = false;
                String[] bl11 = new String[]{"@"};
                String eventType = (String)StringsKt.split$default((CharSequence)dispatchKey, (String[])bl11, (boolean)false, (int)0, (int)6, null).get(0);
                List list2 = (List)repositoryDispatchSenders.get(dispatchKey);
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List senders = list2;
                Iterable $this$forEach$iv9 = senders;
                boolean $i$f$forEach9 = false;
                for (Object element$iv9 : $this$forEach$iv9) {
                    String senderWorkflow = (String)element$iv9;
                    boolean bl13 = false;
                    connections.add("    " + UtilsKt.sanitizeNodeId(senderWorkflow) + " --> " + dispatchNodeId);
                }
                if (!Intrinsics.areEqual((Object)targetRepo, (Object)GitHub.repository.getValue())) continue;
                List list3 = (List)repositoryDispatchReceivers.get(eventType);
                if (list3 == null) {
                    list3 = specificReceivers = CollectionsKt.emptyList();
                }
                if ((list = (List)repositoryDispatchReceivers.get("*")) == null) {
                    list = CollectionsKt.emptyList();
                }
                if ((receivers = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)specificReceivers, (Iterable)(wildcardReceivers = list)))).isEmpty()) {
                    boolean bl14;
                    String noReceiverNodeId;
                    block48: {
                        noReceiverNodeId = UtilsKt.sanitizeNodeId("no_receiver_" + eventType);
                        Iterable $this$any$iv = diagramLines;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl14 = false;
                        } else {
                            for (Object element$iv10 : $this$any$iv) {
                                String it = (String)element$iv10;
                                boolean bl15 = false;
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)("no_receiver_" + eventType), (boolean)false, (int)2, null)) continue;
                                bl14 = true;
                                break block48;
                            }
                            bl14 = false;
                        }
                    }
                    if (!bl14) {
                        diagramLines.add("    " + noReceiverNodeId + "[\"\u274c No receiver<br/>for " + UtilsKt.escapeMermaid(eventType) + "\"]");
                    }
                    object = connections.add("    " + dispatchNodeId + " --> " + noReceiverNodeId);
                    continue;
                }
                Iterable $this$forEach$iv10 = receivers;
                boolean $i$f$forEach10 = false;
                for (Object element$iv11 : $this$forEach$iv10) {
                    String receiverWorkflow = (String)element$iv11;
                    boolean bl16 = false;
                    String eventLabel = Intrinsics.areEqual((Object)eventType, (Object)"*") ? "*" : UtilsKt.escapeMermaid(eventType);
                    String connection = "    " + dispatchNodeId + " -->|\"" + eventLabel + "\"|" + UtilsKt.sanitizeNodeId(receiverWorkflow);
                    connections.add(connection);
                }
                object = Unit.INSTANCE;
            }
        }
        if (!((Collection)allRepositoryDispatchEventTypes).isEmpty() && repositoryDispatchesByRepo.isEmpty()) {
            String thisRepoTarget = GitHub.repository.getValue();
            String dispatchNodeId = UtilsKt.sanitizeNodeId("repository_dispatch_" + thisRepoTarget);
            if (!processedNodes.contains(dispatchNodeId)) {
                String label4 = "\ud83d\udd14 repository_dispatch<br/>\u2192 this repo";
                diagramLines.add("    " + dispatchNodeId + "([\"" + label4 + "\"])");
                processedNodes.add(dispatchNodeId);
            }
            Iterable $this$forEach$iv11 = allRepositoryDispatchEventTypes;
            boolean $i$f$forEach11 = false;
            for (Object element$iv12 : $this$forEach$iv11) {
                List list;
                List specificReceivers;
                String eventType = (String)element$iv12;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)eventType, (Object)"*")) continue;
                List list4 = (List)repositoryDispatchReceivers.get(eventType);
                if (list4 == null) {
                    list4 = specificReceivers = CollectionsKt.emptyList();
                }
                if ((list = (List)repositoryDispatchReceivers.get("*")) == null) {
                    list = CollectionsKt.emptyList();
                }
                List wildcardReceivers = list;
                List receivers = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)specificReceivers, (Iterable)wildcardReceivers));
                Iterable $this$forEach$iv12 = receivers;
                boolean $i$f$forEach12 = false;
                for (Object element$iv13 : $this$forEach$iv12) {
                    String receiverWorkflow = (String)element$iv13;
                    boolean bl17 = false;
                    String eventLabel = UtilsKt.escapeMermaid(eventType);
                    String connection = "    " + dispatchNodeId + " -->|\"" + eventLabel + "\"|" + UtilsKt.sanitizeNodeId(receiverWorkflow);
                    connections.add(connection);
                }
            }
        }
        diagramLines.addAll(connections);
        return CollectionsKt.joinToString$default((Iterable)diagramLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }
}

