/*
 * Decompiled with CFR 0.152.
 */
package io.typeflows.github.visualisation;

import io.typeflows.fs.DirectoryCollector;
import io.typeflows.fs.MarkdownContent;
import io.typeflows.fs.TypeflowsDir;
import io.typeflows.github.visualisation.SingleWorkflowLayout;
import io.typeflows.github.visualisation.WorkflowTriggersFlowchart;
import io.typeflows.github.workflow.Container;
import io.typeflows.github.workflow.Expression;
import io.typeflows.github.workflow.Job;
import io.typeflows.github.workflow.Permissions;
import io.typeflows.github.workflow.Strategy;
import io.typeflows.github.workflow.Workflow;
import io.typeflows.github.workflow.step.ActionStep;
import io.typeflows.github.workflow.step.BaseRun;
import io.typeflows.github.workflow.step.RunCommand;
import io.typeflows.github.workflow.step.RunScript;
import io.typeflows.github.workflow.step.SendRepositoryDispatch;
import io.typeflows.github.workflow.step.Step;
import io.typeflows.util.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/typeflows/github/visualisation/WorkflowVisualisations;", "Lio/typeflows/fs/TypeflowsDir;", "workflows", "Lio/typeflows/fs/DirectoryCollector;", "Lio/typeflows/github/workflow/Workflow;", "<init>", "(Lio/typeflows/fs/DirectoryCollector;)V", "Companion", "typeflows-github"})
@SourceDebugExtension(value={"SMAP\nWorkflowVisualisations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkflowVisualisations.kt\nio/typeflows/github/visualisation/WorkflowVisualisations\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1869#2,2:312\n*S KotlinDebug\n*F\n+ 1 WorkflowVisualisations.kt\nio/typeflows/github/visualisation/WorkflowVisualisations\n*L\n35#1:312,2\n*E\n"})
public final class WorkflowVisualisations
extends TypeflowsDir {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DirectoryCollector<Workflow> workflows;

    /*
     * WARNING - void declaration
     */
    public WorkflowVisualisations(@NotNull DirectoryCollector<Workflow> workflows) {
        void $this$_init__u24lambda_u240;
        TypeflowsDir.DSL dSL;
        Intrinsics.checkNotNullParameter(workflows, (String)"workflows");
        TypeflowsDir.DSL dSL2 = dSL = new TypeflowsDir.DSL(null, 1, null);
        String string = "typeflows";
        WorkflowVisualisations workflowVisualisations = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.files.add((Named)MarkdownContent.Companion.of(WorkflowVisualisations.Companion.buildMainReadme((DirectoryCollector<Workflow>)workflows)).asTypeflowsFile("README.md"));
        Iterable $this$forEach$iv = (Iterable)workflows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Workflow workflow2 = (Workflow)((Object)element$iv);
            boolean bl2 = false;
            String subdirectoryName = StringsKt.removeSuffix((String)workflow2.getName(), (CharSequence)".yml");
            $this$_init__u24lambda_u240.files.add((Named)TypeflowsDir.Companion.invoke(subdirectoryName, arg_0 -> WorkflowVisualisations._init_$lambda$0$0$0(workflow2, arg_0)));
        }
        Unit unit = Unit.INSTANCE;
        super(string, dSL);
        this.workflows = workflows;
    }

    private static final Unit _init_$lambda$0$0$0(Workflow $workflow, TypeflowsDir.DSL $this$TypeflowsDir) {
        Intrinsics.checkNotNullParameter((Object)$this$TypeflowsDir, (String)"$this$TypeflowsDir");
        $this$TypeflowsDir.files.add((Named)MarkdownContent.Companion.of(WorkflowVisualisations.Companion.buildWorkflowReadme($workflow)).asTypeflowsFile("README.md"));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0002J\f\u0010\n\u001a\u00020\u0005*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\u0005*\u00020\u000bH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\f\u0010\u0016\u001a\u00020\u0005*\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\f\u0010\u0019\u001a\u00020\u0005*\u00020\u000bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u001b"}, d2={"Lio/typeflows/github/visualisation/WorkflowVisualisations$Companion;", "", "<init>", "()V", "buildMainReadme", "", "Lio/typeflows/fs/DirectoryCollector;", "Lio/typeflows/github/workflow/Workflow;", "buildWorkflowReadme", "workflow", "buildStepsMarkdown", "Lio/typeflows/github/workflow/Job;", "buildStepsFlowchart", "isLocalAction", "", "Lio/typeflows/github/workflow/step/ActionStep;", "buildSimplifiedStepNode", "step", "Lio/typeflows/github/workflow/step/Step;", "stepNumber", "", "stepName", "buildActionNode", "mapRunnerToEmoji", "runsOnValue", "buildCompactConfigInfo", "stepFallback", "typeflows-github"})
    @SourceDebugExtension(value={"SMAP\nWorkflowVisualisations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkflowVisualisations.kt\nio/typeflows/github/visualisation/WorkflowVisualisations$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n1056#2:312\n1869#2,2:313\n1869#2,2:315\n1878#2,3:317\n1869#2,2:321\n1#3:320\n*S KotlinDebug\n*F\n+ 1 WorkflowVisualisations.kt\nio/typeflows/github/visualisation/WorkflowVisualisations$Companion\n*L\n57#1:312\n57#1:313,2\n80#1:315,2\n129#1:317,3\n238#1:321,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String buildMainReadme(DirectoryCollector<Workflow> $this$buildMainReadme) {
            StringBuilder content = new StringBuilder();
            content.append("# Workflows").append('\n');
            content.append('\n');
            content.append((String)new WorkflowTriggersFlowchart($this$buildMainReadme).build().getValue()).append('\n');
            content.append('\n');
            content.append("## Workflows").append('\n');
            content.append('\n');
            Iterable $this$sortedBy$iv = (Iterable)$this$buildMainReadme;
            boolean $i$f$sortedBy = false;
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Workflow workflow2 = (Workflow)((Object)a);
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)workflow2.getName());
                    workflow2 = (Workflow)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)workflow2.getName())));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Workflow workflow2 = (Workflow)((Object)element$iv);
                boolean bl = false;
                String linkText = workflow2.description != null ? workflow2.displayName + " - " + workflow2.description : workflow2.displayName;
                content.append("- [" + linkText + "](./" + StringsKt.removeSuffix((String)workflow2.getName(), (CharSequence)".yml") + "/)").append('\n');
            }
            String string = content.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String buildWorkflowReadme(Workflow workflow2) {
            StringBuilder markdown = new StringBuilder();
            String title = workflow2.description != null ? "# " + workflow2.safeName() + " - " + workflow2.description : "# " + workflow2.safeName();
            markdown.append(title + " (" + workflow2.getName() + ")").append('\n');
            markdown.append('\n');
            markdown.append((String)new SingleWorkflowLayout(workflow2).build().getValue()).append('\n');
            markdown.append('\n');
            if (!((Collection)workflow2.jobs).isEmpty()) {
                Iterable $this$forEach$iv = workflow2.jobs;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Job job = (Job)((Object)element$iv);
                    boolean bl = false;
                    markdown.append(Companion.buildStepsMarkdown(job)).append('\n');
                    markdown.append('\n');
                }
            }
            String string = markdown.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String buildStepsMarkdown(Job $this$buildStepsMarkdown) {
            StringBuilder markdown = new StringBuilder();
            String string = $this$buildStepsMarkdown.name;
            if (string == null) {
                string = $this$buildStepsMarkdown.id;
            }
            String jobTitle = string;
            markdown.append("## Job: " + jobTitle).append('\n');
            markdown.append('\n');
            String runsOnValue = $this$buildStepsMarkdown.runsOn.render().toString();
            String osEmoji = this.mapRunnerToEmoji(runsOnValue);
            String dependencies = !((Collection)$this$buildStepsMarkdown.needs).isEmpty() ? CollectionsKt.joinToString$default((Iterable)$this$buildStepsMarkdown.needs, (CharSequence)", ", null, null, (int)0, null, Companion::buildStepsMarkdown$lambda$0, (int)30, null) : "-";
            String config = this.buildCompactConfigInfo($this$buildStepsMarkdown);
            markdown.append("| Job | OS | Dependencies | Config |").append('\n');
            markdown.append("|-----|----|--------------|---------| ").append('\n');
            markdown.append("| `" + $this$buildStepsMarkdown.id + "` | " + osEmoji + " " + runsOnValue + " | " + dependencies + " | " + config + " |").append('\n');
            markdown.append('\n');
            String flowchart = this.buildStepsFlowchart($this$buildStepsMarkdown);
            markdown.append(flowchart).append('\n');
            String string2 = markdown.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }

        /*
         * WARNING - void declaration
         */
        private final String buildStepsFlowchart(Job $this$buildStepsFlowchart) {
            StringBuilder flowchart = new StringBuilder();
            flowchart.append("### Steps").append('\n');
            flowchart.append('\n');
            flowchart.append("```mermaid").append('\n');
            flowchart.append("%%{init: {\"flowchart\": {\"curve\": \"basis\"}}}%%").append('\n');
            flowchart.append("flowchart TD").append('\n');
            if ($this$buildStepsFlowchart.steps.isEmpty()) {
                flowchart.append("    nosteps[\"No steps defined\"]").append('\n');
                flowchart.append("    style nosteps fill:#f9f9f9,stroke:#666,stroke-dasharray:5 5").append('\n');
            } else {
                Iterable $this$forEachIndexed$iv = $this$buildStepsFlowchart.steps;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void step;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Step step2 = (Step)((Object)item$iv);
                    int index = n;
                    boolean bl = false;
                    String stepId = "step" + (index + 1);
                    String string = step.name;
                    if (string == null && (string = step.id) == null) {
                        string = Companion.stepFallback((Step)step);
                    }
                    String stepName = string;
                    int stepNumber = index + 1;
                    String stepNode = Companion.buildSimplifiedStepNode((Step)step, stepNumber, stepName);
                    flowchart.append("    " + stepId + "[\"" + stepNode + "\"]").append('\n');
                    void var16_16 = step;
                    StringBuilder stringBuilder = var16_16 instanceof ActionStep ? flowchart.append("    style " + stepId + " fill:#f8f9fa,stroke:#495057").append('\n') : (var16_16 instanceof BaseRun ? flowchart.append("    style " + stepId + " fill:#f3e5f5,stroke:#7b1fa2").append('\n') : flowchart.append("    style " + stepId + " fill:#f1f8e9,stroke:#558b2f").append('\n'));
                    if (step instanceof ActionStep) {
                        String actionId = "action" + (index + 1);
                        String actionNode = Companion.buildActionNode((ActionStep)step);
                        flowchart.append("    " + actionId + actionNode).append('\n');
                        StringBuilder stringBuilder2 = Companion.isLocalAction((ActionStep)step) ? flowchart.append("    style " + actionId + " fill:#e0f7fa,stroke:#00acc1").append('\n') : flowchart.append("    style " + actionId + " fill:#e1f5fe,stroke:#0277bd").append('\n');
                        flowchart.append("    " + stepId + " -.-> " + actionId).append('\n');
                    }
                    if (index <= 0) continue;
                    String prevStepId = "step" + index;
                    flowchart.append("    " + prevStepId + " --> " + stepId).append('\n');
                }
            }
            flowchart.append("```").append('\n');
            flowchart.append('\n');
            flowchart.append("**Step Types Legend:**").append('\n');
            flowchart.append("- \ud83d\udd18 **Step Nodes** (Gray): Workflow step execution").append('\n');
            flowchart.append("- \ud83d\udd35 **Action Blocks** (Blue): External GitHub Actions").append('\n');
            flowchart.append("- \ud83d\udd37 **Action Blocks** (Light Blue): Local repository actions").append('\n');
            flowchart.append("- \ud83d\udfe3 **Script Nodes** (Purple): Run commands/scripts").append('\n');
            flowchart.append("- **Solid arrows** (\u2192): Step execution flow").append('\n');
            flowchart.append("- **Dotted arrows** (-.->): Action usage with inputs").append('\n');
            flowchart.append('\n');
            String string = flowchart.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final boolean isLocalAction(ActionStep $this$isLocalAction) {
            return StringsKt.startsWith$default((String)$this$isLocalAction.getUses(), (String)"./.github/actions/", (boolean)false, (int)2, null);
        }

        private final String buildSimplifiedStepNode(Step step, int stepNumber, String stepName) {
            StringBuilder details = new StringBuilder();
            details.append("Step " + stepNumber + ": " + stepName);
            Expression expression = step.condition;
            if (expression != null) {
                Expression condition = expression;
                boolean bl = false;
                details.append("<br/>\ud83d\udd10 if: " + condition.getValue());
            }
            Step step2 = step;
            if (step2 instanceof ActionStep) {
                Boolean bl;
                Integer n = ((ActionStep)step).timeoutMinutes;
                if (n != null) {
                    timeout = ((Number)n).intValue();
                    boolean bl2 = false;
                    details.append("<br/>\u23f1\ufe0f " + timeout + "m timeout");
                }
                if ((bl = ((ActionStep)step).continueOnError) != null) {
                    Boolean timeout = bl;
                    boolean it = timeout;
                    boolean bl3 = false;
                    bl = it ? timeout : null;
                    if (bl != null) {
                        it = bl;
                        boolean bl4 = false;
                        details.append("<br/>\u26a0\ufe0f Continue on error");
                    }
                }
            } else if (step2 instanceof BaseRun) {
                Boolean bl;
                details.append("<br/>\ud83d\udcbb " + ((BaseRun)step).shell);
                Integer n = ((BaseRun)step).timeoutMinutes;
                if (n != null) {
                    timeout = ((Number)n).intValue();
                    boolean bl5 = false;
                    details.append("<br/>\u23f1\ufe0f " + timeout + "m timeout");
                }
                if ((bl = ((BaseRun)step).continueOnError) != null) {
                    Boolean timeout = bl;
                    boolean it = timeout;
                    boolean bl6 = false;
                    bl = it ? timeout : null;
                    if (bl != null) {
                        it = bl;
                        boolean bl7 = false;
                        details.append("<br/>\u26a0\ufe0f Continue on error");
                    }
                }
                String string = ((BaseRun)step).workingDirectory;
                if (string != null) {
                    String workingDir = string;
                    boolean bl8 = false;
                    details.append("<br/>\ud83d\udcc2 " + workingDir);
                }
            }
            String string = details.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String buildActionNode(ActionStep $this$buildActionNode) {
            Map inputs;
            Object actionName;
            Object object;
            String[] stringArray = new String[]{"/"};
            List actionParts = StringsKt.split$default((CharSequence)$this$buildActionNode.getUses(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            StringBuilder details = new StringBuilder();
            if (this.isLocalAction($this$buildActionNode)) {
                v0 = details.append("\ud83d\udce6 " + $this$buildActionNode.getUses());
            } else {
                String string;
                String actionWithVersion;
                String orgName;
                String string2 = (String)CollectionsKt.getOrNull((List)actionParts, (int)0);
                if (string2 == null) {
                    string2 = orgName = "unknown";
                }
                if (StringsKt.contains$default((CharSequence)(actionWithVersion = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)actionParts, (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null)), (CharSequence)"@", (boolean)false, (int)2, null)) {
                    object = new String[]{"@"};
                    string = (String)StringsKt.split$default((CharSequence)actionWithVersion, (String[])object, (boolean)false, (int)0, (int)6, null).get(0);
                } else {
                    string = actionWithVersion;
                }
                actionName = string;
                v0 = details.append("\ud83c\udfac " + orgName + "<br/>" + (String)actionName);
            }
            actionName = $this$buildActionNode.with;
            Map it = actionName;
            boolean bl = false;
            Object object2 = !it.isEmpty() ? actionName : null;
            if (object2 == null && (object2 = (object = $this$buildActionNode.render().get("with")) instanceof Map ? (Map)object : null) == null) {
                object2 = MapsKt.emptyMap();
            }
            if (!(inputs = object2).isEmpty()) {
                details.append("<br/><br/>\ud83d\udcdd Inputs:");
                Iterable $this$forEach$iv = inputs.entrySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl2 = false;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    String it2 = String.valueOf(value);
                    boolean bl3 = false;
                    String shortValue = it2.length() > 30 ? StringsKt.take((String)it2, (int)30) + "..." : it2;
                    details.append("<br/>\u2022 " + key + ": " + shortValue);
                }
            }
            return "[\"" + details + "\"]";
        }

        private final String mapRunnerToEmoji(String runsOnValue) {
            return StringsKt.contains$default((CharSequence)runsOnValue, (CharSequence)"ubuntu", (boolean)false, (int)2, null) ? "\ud83d\udc27" : (StringsKt.contains$default((CharSequence)runsOnValue, (CharSequence)"windows", (boolean)false, (int)2, null) ? "\ud83e\ude9f" : (StringsKt.contains$default((CharSequence)runsOnValue, (CharSequence)"macos", (boolean)false, (int)2, null) ? "\ud83c\udf4e" : (StringsKt.contains$default((CharSequence)runsOnValue, (CharSequence)"self-hosted", (boolean)false, (int)2, null) ? "\ud83c\udfe0" : (StringsKt.contains$default((CharSequence)runsOnValue, (CharSequence)"group", (boolean)false, (int)2, null) ? "\ud83c\udfaf" : "\ud83d\udcbb"))));
        }

        private final String buildCompactConfigInfo(Job $this$buildCompactConfigInfo) {
            List configParts;
            block8: {
                Boolean bl;
                configParts = new ArrayList();
                Integer n = $this$buildCompactConfigInfo.timeoutMinutes;
                if (n != null) {
                    int timeout = ((Number)n).intValue();
                    boolean bl2 = false;
                    configParts.add("\u23f1\ufe0f " + timeout + "m");
                }
                Expression expression = $this$buildCompactConfigInfo.condition;
                if (expression != null) {
                    Expression condition = expression;
                    boolean bl3 = false;
                    configParts.add("\ud83d\udd10 if");
                }
                if ((bl = $this$buildCompactConfigInfo.continueOnError) != null) {
                    Boolean condition = bl;
                    boolean it = condition;
                    boolean bl4 = false;
                    bl = it ? condition : null;
                    if (bl != null) {
                        it = bl;
                        boolean bl5 = false;
                        configParts.add("\u26a0\ufe0f continue");
                    }
                }
                if (!$this$buildCompactConfigInfo.env.isEmpty()) {
                    configParts.add("\ud83c\udf0d env");
                }
                Container container = $this$buildCompactConfigInfo.container;
                if (container != null) {
                    Container it = container;
                    boolean bl6 = false;
                    configParts.add("\ud83d\udc33 container");
                }
                Strategy strategy = $this$buildCompactConfigInfo.strategy;
                if (strategy != null) {
                    Strategy it = strategy;
                    boolean bl7 = false;
                    configParts.add("\ud83d\udd04 matrix");
                }
                if (!((Collection)$this$buildCompactConfigInfo.outputs).isEmpty()) {
                    configParts.add("\ud83d\udce4 " + $this$buildCompactConfigInfo.outputs.size() + " outputs");
                }
                Permissions permissions = $this$buildCompactConfigInfo.permissions;
                if (permissions == null) break block8;
                Permissions it = permissions;
                boolean bl8 = false;
                configParts.add("\ud83d\udd10 perms");
            }
            return configParts.isEmpty() ? "-" : CollectionsKt.joinToString$default((Iterable)configParts, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String stepFallback(Step step) {
            Step step2 = step;
            if (!(step2 instanceof ActionStep)) {
                if (step2 instanceof RunCommand) {
                    return "Run command";
                }
                if (step2 instanceof RunScript) {
                    return "Run script";
                }
                if (!(step2 instanceof SendRepositoryDispatch)) return "Step";
                return "Send Repository Dispatch";
            }
            String[] stringArray = new String[]{"/"};
            String string = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)((ActionStep)step).getUses(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (string == null) return "Use action";
            String[] stringArray2 = new String[]{"@"};
            List list = StringsKt.split$default((CharSequence)string, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (list == null) return "Use action";
            String string2 = (String)CollectionsKt.firstOrNull((List)list);
            if (string2 == null) return "Use action";
            String string3 = string2;
            boolean bl = false;
            String string4 = "Use " + string3;
            if (string4 == null) return "Use action";
            String string5 = string4;
            return string5;
        }

        private static final CharSequence buildStepsMarkdown$lambda$0(Job it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return "`" + it.id + "`";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

