/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sendly.models.BatchMessageResult;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;

public class BatchMessageResponse {
    public static final String STATUS_PROCESSING = "processing";
    public static final String STATUS_COMPLETED = "completed";
    public static final String STATUS_PARTIALLY_COMPLETED = "partially_completed";
    public static final String STATUS_FAILED = "failed";
    private final String batchId;
    private final String status;
    private final int total;
    private final int queued;
    private final int failed;
    private final int creditsUsed;
    private final List<BatchMessageResult> messages;
    private final Instant createdAt;
    private final Instant completedAt;

    public BatchMessageResponse(JsonObject json) {
        this.batchId = this.getStringOrNull(json, "batch_id");
        this.status = this.getStringOrNull(json, "status");
        this.total = json.has("total") ? json.get("total").getAsInt() : 0;
        this.queued = json.has("queued") ? json.get("queued").getAsInt() : 0;
        this.failed = json.has(STATUS_FAILED) ? json.get(STATUS_FAILED).getAsInt() : 0;
        this.creditsUsed = json.has("credits_used") ? json.get("credits_used").getAsInt() : 0;
        this.createdAt = this.parseInstant(this.getStringOrNull(json, "created_at"));
        this.completedAt = this.parseInstant(this.getStringOrNull(json, "completed_at"));
        this.messages = new ArrayList<BatchMessageResult>();
        if (json.has("messages") && json.get("messages").isJsonArray()) {
            JsonArray messagesArray = json.getAsJsonArray("messages");
            for (JsonElement element : messagesArray) {
                this.messages.add(new BatchMessageResult(element.getAsJsonObject()));
            }
        }
    }

    private String getStringOrNull(JsonObject json, String key) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
    }

    private Instant parseInstant(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getBatchId() {
        return this.batchId;
    }

    public String getStatus() {
        return this.status;
    }

    public int getTotal() {
        return this.total;
    }

    public int getQueued() {
        return this.queued;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getCreditsUsed() {
        return this.creditsUsed;
    }

    public List<BatchMessageResult> getMessages() {
        return this.messages;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getCompletedAt() {
        return this.completedAt;
    }

    public boolean isProcessing() {
        return STATUS_PROCESSING.equals(this.status);
    }

    public boolean isCompleted() {
        return STATUS_COMPLETED.equals(this.status);
    }

    public boolean isPartiallyCompleted() {
        return STATUS_PARTIALLY_COMPLETED.equals(this.status);
    }

    public boolean isFailed() {
        return STATUS_FAILED.equals(this.status);
    }

    public String toString() {
        return "BatchMessageResponse{batchId='" + this.batchId + "', status='" + this.status + "', total=" + this.total + ", queued=" + this.queued + ", failed=" + this.failed + ", creditsUsed=" + this.creditsUsed + "}";
    }
}

