/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public class Message {
    public static final String STATUS_QUEUED = "queued";
    public static final String STATUS_SENDING = "sending";
    public static final String STATUS_SENT = "sent";
    public static final String STATUS_DELIVERED = "delivered";
    public static final String STATUS_FAILED = "failed";
    private final String id;
    private final String to;
    private final String text;
    private final String status;
    @SerializedName(value="credits_used")
    private final int creditsUsed;
    @SerializedName(value="created_at")
    private final Instant createdAt;
    @SerializedName(value="updated_at")
    private final Instant updatedAt;
    @SerializedName(value="delivered_at")
    private final Instant deliveredAt;
    @SerializedName(value="error_code")
    private final String errorCode;
    @SerializedName(value="error_message")
    private final String errorMessage;

    public Message(JsonObject json) {
        this.id = this.getStringOrNull(json, "id");
        this.to = this.getStringOrNull(json, "to");
        this.text = this.getStringOrNull(json, "text");
        this.status = this.getStringOrNull(json, "status");
        this.creditsUsed = json.has("credits_used") ? json.get("credits_used").getAsInt() : 0;
        this.createdAt = this.parseInstant(this.getStringOrNull(json, "created_at"));
        this.updatedAt = this.parseInstant(this.getStringOrNull(json, "updated_at"));
        this.deliveredAt = this.parseInstant(this.getStringOrNull(json, "delivered_at"));
        this.errorCode = this.getStringOrNull(json, "error_code");
        this.errorMessage = this.getStringOrNull(json, "error_message");
    }

    private String getStringOrNull(JsonObject json, String key) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
    }

    private Instant parseInstant(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTo() {
        return this.to;
    }

    public String getText() {
        return this.text;
    }

    public String getStatus() {
        return this.status;
    }

    public int getCreditsUsed() {
        return this.creditsUsed;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public Instant getDeliveredAt() {
        return this.deliveredAt;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isDelivered() {
        return STATUS_DELIVERED.equals(this.status);
    }

    public boolean isFailed() {
        return STATUS_FAILED.equals(this.status);
    }

    public boolean isPending() {
        return STATUS_QUEUED.equals(this.status) || STATUS_SENDING.equals(this.status) || STATUS_SENT.equals(this.status);
    }

    public String toString() {
        return "Message{id='" + this.id + "', to='" + this.to + "', status='" + this.status + "', creditsUsed=" + this.creditsUsed + "}";
    }
}

