/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

public class ScheduleMessageRequest {
    private final String to;
    private final String text;
    private final String scheduledAt;
    private final String from;

    public ScheduleMessageRequest(String to, String text, String scheduledAt) {
        this(to, text, scheduledAt, null);
    }

    public ScheduleMessageRequest(String to, String text, String scheduledAt, String from) {
        this.to = to;
        this.text = text;
        this.scheduledAt = scheduledAt;
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public String getText() {
        return this.text;
    }

    public String getScheduledAt() {
        return this.scheduledAt;
    }

    public String getFrom() {
        return this.from;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String to;
        private String text;
        private String scheduledAt;
        private String from;

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder scheduledAt(String scheduledAt) {
            this.scheduledAt = scheduledAt;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public ScheduleMessageRequest build() {
            return new ScheduleMessageRequest(this.to, this.text, this.scheduledAt, this.from);
        }
    }
}

