/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.resources;

import com.google.gson.JsonObject;
import com.sendly.Sendly;
import com.sendly.exceptions.SendlyException;
import com.sendly.exceptions.ValidationException;
import com.sendly.models.BatchList;
import com.sendly.models.BatchMessageItem;
import com.sendly.models.BatchMessageResponse;
import com.sendly.models.CancelScheduledMessageResponse;
import com.sendly.models.ListBatchesRequest;
import com.sendly.models.ListMessagesRequest;
import com.sendly.models.ListScheduledMessagesRequest;
import com.sendly.models.Message;
import com.sendly.models.MessageList;
import com.sendly.models.ScheduleMessageRequest;
import com.sendly.models.ScheduledMessage;
import com.sendly.models.ScheduledMessageList;
import com.sendly.models.SendBatchRequest;
import com.sendly.models.SendMessageRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

public class Messages {
    private static final Pattern PHONE_PATTERN = Pattern.compile("^\\+[1-9]\\d{1,14}$");
    private static final int MAX_TEXT_LENGTH = 1600;
    private final Sendly client;

    public Messages(Sendly client) {
        this.client = client;
    }

    public Message send(String to, String text) throws SendlyException {
        return this.send(new SendMessageRequest(to, text));
    }

    public Message send(SendMessageRequest request) throws SendlyException {
        this.validatePhone(request.getTo());
        this.validateText(request.getText());
        JsonObject response = this.client.post("/messages", request);
        JsonObject data = response.has("message") ? response.getAsJsonObject("message") : (response.has("data") ? response.getAsJsonObject("data") : response);
        return new Message(data);
    }

    public MessageList list() throws SendlyException {
        return this.list(ListMessagesRequest.builder().build());
    }

    public MessageList list(ListMessagesRequest request) throws SendlyException {
        JsonObject response = this.client.get("/messages", request.toParams());
        return new MessageList(response);
    }

    public Message get(String id) throws SendlyException {
        if (id == null || id.isEmpty()) {
            throw new ValidationException("Message ID is required");
        }
        JsonObject response = this.client.get("/messages/" + id, null);
        JsonObject data = response.has("data") ? response.getAsJsonObject("data") : (response.has("message") ? response.getAsJsonObject("message") : response);
        return new Message(data);
    }

    public Iterable<Message> each() {
        return this.each(ListMessagesRequest.builder().build());
    }

    public Iterable<Message> each(ListMessagesRequest request) {
        return () -> new MessageIterator(this, request);
    }

    public ScheduledMessage schedule(String to, String text, String scheduledAt) throws SendlyException {
        return this.schedule(new ScheduleMessageRequest(to, text, scheduledAt));
    }

    public ScheduledMessage schedule(ScheduleMessageRequest request) throws SendlyException {
        this.validatePhone(request.getTo());
        this.validateText(request.getText());
        this.validateScheduledAt(request.getScheduledAt());
        JsonObject response = this.client.post("/messages/schedule", request);
        JsonObject data = response.has("data") ? response.getAsJsonObject("data") : response;
        return new ScheduledMessage(data);
    }

    public ScheduledMessageList listScheduled() throws SendlyException {
        return this.listScheduled(ListScheduledMessagesRequest.builder().build());
    }

    public ScheduledMessageList listScheduled(ListScheduledMessagesRequest request) throws SendlyException {
        JsonObject response = this.client.get("/messages/scheduled", request.toParams());
        return new ScheduledMessageList(response);
    }

    public ScheduledMessage getScheduled(String id) throws SendlyException {
        if (id == null || id.isEmpty()) {
            throw new ValidationException("Scheduled message ID is required");
        }
        String encodedId = this.encodePathParam(id);
        JsonObject response = this.client.get("/messages/scheduled/" + encodedId, null);
        JsonObject data = response.has("data") ? response.getAsJsonObject("data") : response;
        return new ScheduledMessage(data);
    }

    public CancelScheduledMessageResponse cancelScheduled(String id) throws SendlyException {
        if (id == null || id.isEmpty()) {
            throw new ValidationException("Scheduled message ID is required");
        }
        String encodedId = this.encodePathParam(id);
        JsonObject response = this.client.delete("/messages/scheduled/" + encodedId);
        return new CancelScheduledMessageResponse(response);
    }

    public BatchMessageResponse sendBatch(SendBatchRequest request) throws SendlyException {
        if (request.getMessages() == null || request.getMessages().isEmpty()) {
            throw new ValidationException("At least one message is required");
        }
        for (BatchMessageItem item : request.getMessages()) {
            this.validatePhone(item.getTo());
            this.validateText(item.getText());
        }
        JsonObject response = this.client.post("/messages/batch", request);
        return new BatchMessageResponse(response);
    }

    public BatchMessageResponse getBatch(String batchId) throws SendlyException {
        if (batchId == null || batchId.isEmpty()) {
            throw new ValidationException("Batch ID is required");
        }
        String encodedId = this.encodePathParam(batchId);
        JsonObject response = this.client.get("/messages/batch/" + encodedId, null);
        return new BatchMessageResponse(response);
    }

    public BatchList listBatches() throws SendlyException {
        return this.listBatches(ListBatchesRequest.builder().build());
    }

    public BatchList listBatches(ListBatchesRequest request) throws SendlyException {
        JsonObject response = this.client.get("/messages/batches", request.toParams());
        return new BatchList(response);
    }

    private void validatePhone(String phone) throws ValidationException {
        if (phone == null || !PHONE_PATTERN.matcher(phone).matches()) {
            throw new ValidationException("Invalid phone number format. Use E.164 format (e.g., +15551234567)");
        }
    }

    private void validateText(String text) throws ValidationException {
        if (text == null || text.isEmpty()) {
            throw new ValidationException("Message text is required");
        }
        if (text.length() > 1600) {
            throw new ValidationException("Message text exceeds maximum length (1600 characters)");
        }
    }

    private void validateScheduledAt(String scheduledAt) throws ValidationException {
        if (scheduledAt == null || scheduledAt.isEmpty()) {
            throw new ValidationException("Scheduled time is required");
        }
        if (!scheduledAt.matches("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}.*$")) {
            throw new ValidationException("Invalid scheduled time format. Use ISO 8601 format (e.g., 2025-01-20T10:00:00Z)");
        }
    }

    private String encodePathParam(String param) {
        try {
            return URLEncoder.encode(param, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return param;
        }
    }

    private static class MessageIterator
    implements Iterator<Message> {
        private final Messages messages;
        private final String status;
        private final String to;
        private final int batchSize;
        private MessageList currentPage;
        private Iterator<Message> pageIterator;
        private int offset;

        MessageIterator(Messages messages, ListMessagesRequest request) {
            this.messages = messages;
            this.status = null;
            this.to = null;
            this.batchSize = 100;
            this.offset = 0;
            this.fetchNextPage();
        }

        private void fetchNextPage() {
            try {
                this.currentPage = this.messages.list(ListMessagesRequest.builder().limit(this.batchSize).offset(this.offset).status(this.status).to(this.to).build());
                this.pageIterator = this.currentPage.iterator();
                this.offset += this.batchSize;
            }
            catch (SendlyException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.pageIterator.hasNext()) {
                return true;
            }
            if (this.currentPage.hasMore()) {
                this.fetchNextPage();
                return this.pageIterator.hasNext();
            }
            return false;
        }

        @Override
        public Message next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.pageIterator.next();
        }
    }
}

