/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.sendly.models.BatchMessageItem;
import java.util.ArrayList;
import java.util.List;

public class SendBatchRequest {
    private final List<BatchMessageItem> messages;
    private final String from;

    public SendBatchRequest(List<BatchMessageItem> messages) {
        this(messages, null);
    }

    public SendBatchRequest(List<BatchMessageItem> messages, String from) {
        this.messages = messages;
        this.from = from;
    }

    public List<BatchMessageItem> getMessages() {
        return this.messages;
    }

    public String getFrom() {
        return this.from;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<BatchMessageItem> messages = new ArrayList<BatchMessageItem>();
        private String from;

        public Builder addMessage(String to, String text) {
            this.messages.add(new BatchMessageItem(to, text));
            return this;
        }

        public Builder addMessage(BatchMessageItem item) {
            this.messages.add(item);
            return this;
        }

        public Builder messages(List<BatchMessageItem> messages) {
            this.messages = messages;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public SendBatchRequest build() {
            return new SendBatchRequest(this.messages, this.from);
        }
    }
}

