/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sendly.Sendly;
import com.sendly.exceptions.SendlyException;
import com.sendly.exceptions.ValidationException;
import com.sendly.models.Webhook;
import com.sendly.models.WebhookCreatedResponse;
import com.sendly.models.WebhookDelivery;
import com.sendly.models.WebhookTestResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WebhooksResource {
    private final Sendly client;

    public WebhooksResource(Sendly client) {
        this.client = client;
    }

    public WebhookCreatedResponse create(String url, List<String> events) throws SendlyException {
        return this.create(url, events, null, null);
    }

    public WebhookCreatedResponse create(String url, List<String> events, String description, Map<String, Object> metadata) throws SendlyException {
        if (url == null || !url.startsWith("https://")) {
            throw new ValidationException("Webhook URL must be HTTPS");
        }
        if (events == null || events.isEmpty()) {
            throw new ValidationException("At least one event type is required");
        }
        JsonObject body = new JsonObject();
        body.addProperty("url", url);
        JsonArray eventsArray = new JsonArray();
        events.forEach(arg_0 -> ((JsonArray)eventsArray).add(arg_0));
        body.add("events", (JsonElement)eventsArray);
        if (description != null) {
            body.addProperty("description", description);
        }
        if (metadata != null) {
            body.add("metadata", this.client.getGson().toJsonTree(metadata));
        }
        JsonObject response = this.client.post("/webhooks", body);
        return new WebhookCreatedResponse(response);
    }

    public List<Webhook> list() throws SendlyException {
        JsonObject response = this.client.get("/webhooks", null);
        ArrayList<Webhook> webhooks = new ArrayList<Webhook>();
        if (response.has("data") && response.get("data").isJsonArray()) {
            response.getAsJsonArray("data").forEach(e -> webhooks.add(new Webhook(e.getAsJsonObject())));
        } else if (response.isJsonArray()) {
            JsonArray array = (JsonArray)this.client.getGson().fromJson(response.toString(), JsonArray.class);
            array.forEach(e -> webhooks.add(new Webhook(e.getAsJsonObject())));
        }
        return webhooks;
    }

    public Webhook get(String webhookId) throws SendlyException {
        this.validateWebhookId(webhookId);
        JsonObject response = this.client.get("/webhooks/" + webhookId, null);
        return new Webhook(response);
    }

    public Webhook update(String webhookId, String url, List<String> events, String description, Boolean isActive) throws SendlyException {
        this.validateWebhookId(webhookId);
        if (url != null && !url.startsWith("https://")) {
            throw new ValidationException("Webhook URL must be HTTPS");
        }
        JsonObject body = new JsonObject();
        if (url != null) {
            body.addProperty("url", url);
        }
        if (events != null) {
            JsonArray eventsArray = new JsonArray();
            events.forEach(arg_0 -> ((JsonArray)eventsArray).add(arg_0));
            body.add("events", (JsonElement)eventsArray);
        }
        if (description != null) {
            body.addProperty("description", description);
        }
        if (isActive != null) {
            body.addProperty("is_active", isActive);
        }
        JsonObject response = this.client.patch("/webhooks/" + webhookId, body);
        return new Webhook(response);
    }

    public void delete(String webhookId) throws SendlyException {
        this.validateWebhookId(webhookId);
        this.client.delete("/webhooks/" + webhookId);
    }

    public WebhookTestResult test(String webhookId) throws SendlyException {
        this.validateWebhookId(webhookId);
        JsonObject response = this.client.post("/webhooks/" + webhookId + "/test", new JsonObject());
        return new WebhookTestResult(response);
    }

    public WebhookCreatedResponse rotateSecret(String webhookId) throws SendlyException {
        JsonObject webhookJson;
        this.validateWebhookId(webhookId);
        JsonObject response = this.client.post("/webhooks/" + webhookId + "/rotate-secret", new JsonObject());
        JsonObject jsonObject = webhookJson = response.has("webhook") ? response.getAsJsonObject("webhook") : response;
        if (response.has("new_secret") || response.has("newSecret")) {
            webhookJson.addProperty("secret", response.has("new_secret") ? response.get("new_secret").getAsString() : response.get("newSecret").getAsString());
        }
        return new WebhookCreatedResponse(webhookJson);
    }

    public List<WebhookDelivery> getDeliveries(String webhookId) throws SendlyException {
        this.validateWebhookId(webhookId);
        JsonObject response = this.client.get("/webhooks/" + webhookId + "/deliveries", null);
        ArrayList<WebhookDelivery> deliveries = new ArrayList<WebhookDelivery>();
        if (response.has("data") && response.get("data").isJsonArray()) {
            response.getAsJsonArray("data").forEach(e -> deliveries.add(new WebhookDelivery(e.getAsJsonObject())));
        }
        return deliveries;
    }

    public void retryDelivery(String webhookId, String deliveryId) throws SendlyException {
        this.validateWebhookId(webhookId);
        if (deliveryId == null || !deliveryId.startsWith("del_")) {
            throw new ValidationException("Invalid delivery ID format");
        }
        this.client.post("/webhooks/" + webhookId + "/deliveries/" + deliveryId + "/retry", new JsonObject());
    }

    private void validateWebhookId(String webhookId) {
        if (webhookId == null || !webhookId.startsWith("whk_")) {
            throw new ValidationException("Invalid webhook ID format");
        }
    }
}

