/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public class Message {
    public static final String STATUS_QUEUED = "queued";
    public static final String STATUS_SENT = "sent";
    public static final String STATUS_DELIVERED = "delivered";
    public static final String STATUS_FAILED = "failed";
    public static final String STATUS_BOUNCED = "bounced";
    public static final String SENDER_TYPE_NUMBER_POOL = "number_pool";
    public static final String SENDER_TYPE_ALPHANUMERIC = "alphanumeric";
    public static final String SENDER_TYPE_SANDBOX = "sandbox";
    private final String id;
    private final String to;
    private final String from;
    private final String text;
    private final String status;
    private final String direction;
    private final int segments;
    @SerializedName(value="credits_used")
    private final int creditsUsed;
    @SerializedName(value="is_sandbox")
    private final boolean isSandbox;
    @SerializedName(value="sender_type")
    private final String senderType;
    @SerializedName(value="telnyx_message_id")
    private final String telnyxMessageId;
    private final String warning;
    @SerializedName(value="sender_note")
    private final String senderNote;
    @SerializedName(value="created_at")
    private final Instant createdAt;
    @SerializedName(value="updated_at")
    private final Instant updatedAt;
    @SerializedName(value="delivered_at")
    private final Instant deliveredAt;
    @SerializedName(value="error_code")
    private final String errorCode;
    @SerializedName(value="error_message")
    private final String errorMessage;

    public Message(JsonObject json) {
        this.id = this.getStringOrNull(json, "id");
        this.to = this.getStringOrNull(json, "to");
        this.from = this.getStringOrNull(json, "from");
        this.text = this.getStringOrNull(json, "text");
        this.status = this.getStringOrNull(json, "status");
        this.direction = json.has("direction") ? json.get("direction").getAsString() : "outbound";
        int n = this.segments = json.has("segments") ? json.get("segments").getAsInt() : 1;
        int n2 = json.has("credits_used") || json.has("creditsUsed") ? (json.has("credits_used") ? json.get("credits_used").getAsInt() : json.get("creditsUsed").getAsInt()) : (this.creditsUsed = 0);
        this.isSandbox = json.has("is_sandbox") || json.has("isSandbox") ? (json.has("is_sandbox") ? json.get("is_sandbox").getAsBoolean() : json.get("isSandbox").getAsBoolean()) : false;
        this.senderType = this.getStringOrNull(json, "sender_type", "senderType");
        this.telnyxMessageId = this.getStringOrNull(json, "telnyx_message_id", "telnyxMessageId");
        this.warning = this.getStringOrNull(json, "warning");
        this.senderNote = this.getStringOrNull(json, "sender_note", "senderNote");
        this.createdAt = this.parseInstant(this.getStringOrNull(json, "created_at", "createdAt"));
        this.updatedAt = this.parseInstant(this.getStringOrNull(json, "updated_at", "updatedAt"));
        this.deliveredAt = this.parseInstant(this.getStringOrNull(json, "delivered_at", "deliveredAt"));
        this.errorCode = this.getStringOrNull(json, "error_code", "errorCode");
        this.errorMessage = this.getStringOrNull(json, "error_message", "errorMessage");
    }

    private String getStringOrNull(JsonObject json, String key) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
    }

    private String getStringOrNull(JsonObject json, String key1, String key2) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsString();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsString();
        }
        return null;
    }

    private Instant parseInstant(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public String getText() {
        return this.text;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDirection() {
        return this.direction;
    }

    public int getSegments() {
        return this.segments;
    }

    public int getCreditsUsed() {
        return this.creditsUsed;
    }

    public boolean isSandbox() {
        return this.isSandbox;
    }

    public String getSenderType() {
        return this.senderType;
    }

    public String getTelnyxMessageId() {
        return this.telnyxMessageId;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getSenderNote() {
        return this.senderNote;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public Instant getDeliveredAt() {
        return this.deliveredAt;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isDelivered() {
        return STATUS_DELIVERED.equals(this.status);
    }

    public boolean isFailed() {
        return STATUS_FAILED.equals(this.status);
    }

    public boolean isBounced() {
        return STATUS_BOUNCED.equals(this.status);
    }

    public boolean isPending() {
        return STATUS_QUEUED.equals(this.status) || STATUS_SENT.equals(this.status);
    }

    public String toString() {
        return "Message{id='" + this.id + "', to='" + this.to + "', from='" + this.from + "', status='" + this.status + "', direction='" + this.direction + "', creditsUsed=" + this.creditsUsed + "}";
    }
}

