/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

public class ScheduleMessageRequest {
    private final String to;
    private final String text;
    private final String scheduledAt;
    private final String from;
    private final String messageType;

    public ScheduleMessageRequest(String to, String text, String scheduledAt) {
        this(to, text, scheduledAt, null, null);
    }

    public ScheduleMessageRequest(String to, String text, String scheduledAt, String from) {
        this(to, text, scheduledAt, from, null);
    }

    public ScheduleMessageRequest(String to, String text, String scheduledAt, String from, String messageType) {
        this.to = to;
        this.text = text;
        this.scheduledAt = scheduledAt;
        this.from = from;
        this.messageType = messageType;
    }

    public String getTo() {
        return this.to;
    }

    public String getText() {
        return this.text;
    }

    public String getScheduledAt() {
        return this.scheduledAt;
    }

    public String getFrom() {
        return this.from;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String to;
        private String text;
        private String scheduledAt;
        private String from;
        private String messageType;

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder scheduledAt(String scheduledAt) {
            this.scheduledAt = scheduledAt;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public ScheduleMessageRequest build() {
            return new ScheduleMessageRequest(this.to, this.text, this.scheduledAt, this.from, this.messageType);
        }
    }
}

