/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Webhook {
    public static final String CIRCUIT_CLOSED = "closed";
    public static final String CIRCUIT_OPEN = "open";
    public static final String CIRCUIT_HALF_OPEN = "half_open";
    public static final String MODE_ALL = "all";
    public static final String MODE_TEST = "test";
    public static final String MODE_LIVE = "live";
    private final String id;
    private final String url;
    private final List<String> events;
    private final String description;
    private final String mode;
    private final boolean isActive;
    private final int failureCount;
    private final Instant lastFailureAt;
    private final String circuitState;
    private final Instant circuitOpenedAt;
    private final String apiVersion;
    private final Map<String, Object> metadata;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final int totalDeliveries;
    private final int successfulDeliveries;
    private final double successRate;
    private final Instant lastDeliveryAt;

    public Webhook(JsonObject json) {
        this.id = this.getStringOrNull(json, "id");
        this.url = this.getStringOrNull(json, "url");
        this.events = this.parseEvents(json);
        this.description = this.getStringOrNull(json, "description");
        this.mode = this.getStringOrDefault(json, "mode", "mode", MODE_ALL);
        this.isActive = this.getBooleanOrDefault(json, "is_active", "isActive", false);
        this.failureCount = this.getIntOrDefault(json, "failure_count", "failureCount", 0);
        this.lastFailureAt = this.parseInstant(this.getStringOrNull(json, "last_failure_at", "lastFailureAt"));
        this.circuitState = this.getStringOrDefault(json, "circuit_state", "circuitState", CIRCUIT_CLOSED);
        this.circuitOpenedAt = this.parseInstant(this.getStringOrNull(json, "circuit_opened_at", "circuitOpenedAt"));
        this.apiVersion = this.getStringOrDefault(json, "api_version", "apiVersion", "2024-01");
        this.metadata = this.parseMetadata(json);
        this.createdAt = this.parseInstant(this.getStringOrNull(json, "created_at", "createdAt"));
        this.updatedAt = this.parseInstant(this.getStringOrNull(json, "updated_at", "updatedAt"));
        this.totalDeliveries = this.getIntOrDefault(json, "total_deliveries", "totalDeliveries", 0);
        this.successfulDeliveries = this.getIntOrDefault(json, "successful_deliveries", "successfulDeliveries", 0);
        this.successRate = this.getDoubleOrDefault(json, "success_rate", "successRate", 0.0);
        this.lastDeliveryAt = this.parseInstant(this.getStringOrNull(json, "last_delivery_at", "lastDeliveryAt"));
    }

    private List<String> parseEvents(JsonObject json) {
        ArrayList<String> result = new ArrayList<String>();
        if (json.has("events") && json.get("events").isJsonArray()) {
            json.getAsJsonArray("events").forEach(e -> result.add(e.getAsString()));
        }
        return result;
    }

    private Map<String, Object> parseMetadata(JsonObject json) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (json.has("metadata") && json.get("metadata").isJsonObject()) {
            json.getAsJsonObject("metadata").entrySet().forEach(e -> result.put((String)e.getKey(), ((JsonElement)e.getValue()).isJsonPrimitive() ? ((JsonElement)e.getValue()).getAsString() : e.getValue()));
        }
        return result;
    }

    private String getStringOrNull(JsonObject json, String key) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
    }

    private String getStringOrNull(JsonObject json, String key1, String key2) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsString();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsString();
        }
        return null;
    }

    private String getStringOrDefault(JsonObject json, String key1, String key2, String defaultVal) {
        String val = this.getStringOrNull(json, key1, key2);
        return val != null ? val : defaultVal;
    }

    private boolean getBooleanOrDefault(JsonObject json, String key1, String key2, boolean defaultVal) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsBoolean();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsBoolean();
        }
        return defaultVal;
    }

    private int getIntOrDefault(JsonObject json, String key1, String key2, int defaultVal) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsInt();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsInt();
        }
        return defaultVal;
    }

    private double getDoubleOrDefault(JsonObject json, String key1, String key2, double defaultVal) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsDouble();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsDouble();
        }
        return defaultVal;
    }

    private Instant parseInstant(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public List<String> getEvents() {
        return this.events;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public Instant getLastFailureAt() {
        return this.lastFailureAt;
    }

    public String getCircuitState() {
        return this.circuitState;
    }

    public Instant getCircuitOpenedAt() {
        return this.circuitOpenedAt;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public int getTotalDeliveries() {
        return this.totalDeliveries;
    }

    public int getSuccessfulDeliveries() {
        return this.successfulDeliveries;
    }

    public double getSuccessRate() {
        return this.successRate;
    }

    public Instant getLastDeliveryAt() {
        return this.lastDeliveryAt;
    }

    public boolean isCircuitOpen() {
        return CIRCUIT_OPEN.equals(this.circuitState);
    }

    public String toString() {
        return "Webhook{id='" + this.id + "', url='" + this.url + "', isActive=" + this.isActive + "}";
    }
}

