/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sendly.Sendly;
import com.sendly.exceptions.SendlyException;
import com.sendly.exceptions.ValidationException;
import com.sendly.models.Account;
import com.sendly.models.ApiKey;
import com.sendly.models.CreditTransaction;
import com.sendly.models.Credits;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AccountResource {
    private final Sendly client;

    public AccountResource(Sendly client) {
        this.client = client;
    }

    public Account get() throws SendlyException {
        JsonObject response = this.client.get("/account", null);
        JsonObject data = response.has("account") ? response.getAsJsonObject("account") : (response.has("data") ? response.getAsJsonObject("data") : response);
        return new Account(data);
    }

    public Credits getCredits() throws SendlyException {
        JsonObject response = this.client.get("/credits", null);
        JsonObject data = response.has("credits") ? response.getAsJsonObject("credits") : (response.has("data") ? response.getAsJsonObject("data") : response);
        return new Credits(data);
    }

    public List<CreditTransaction> getCreditTransactions() throws SendlyException {
        return this.getCreditTransactions(null, null);
    }

    public List<CreditTransaction> getCreditTransactions(Integer limit, Integer offset) throws SendlyException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (limit != null) {
            params.put("limit", String.valueOf(limit));
        }
        if (offset != null) {
            params.put("offset", String.valueOf(offset));
        }
        JsonObject response = this.client.get("/credits/transactions", params.isEmpty() ? null : params);
        ArrayList<CreditTransaction> transactions = new ArrayList<CreditTransaction>();
        JsonArray array = null;
        if (response.has("data") && response.get("data").isJsonArray()) {
            array = response.getAsJsonArray("data");
        } else if (response.has("transactions") && response.get("transactions").isJsonArray()) {
            array = response.getAsJsonArray("transactions");
        }
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                transactions.add(new CreditTransaction(array.get(i).getAsJsonObject()));
            }
        }
        return transactions;
    }

    public List<ApiKey> listApiKeys() throws SendlyException {
        JsonObject response = this.client.get("/account/keys", null);
        ArrayList<ApiKey> keys = new ArrayList<ApiKey>();
        JsonArray array = null;
        if (response.has("data") && response.get("data").isJsonArray()) {
            array = response.getAsJsonArray("data");
        } else if (response.has("keys") && response.get("keys").isJsonArray()) {
            array = response.getAsJsonArray("keys");
        }
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                keys.add(new ApiKey(array.get(i).getAsJsonObject()));
            }
        }
        return keys;
    }

    public ApiKey getApiKey(String keyId) throws SendlyException {
        if (keyId == null || keyId.isEmpty()) {
            throw new ValidationException("API key ID is required");
        }
        JsonObject response = this.client.get("/account/keys/" + keyId, null);
        JsonObject data = response.has("key") ? response.getAsJsonObject("key") : (response.has("data") ? response.getAsJsonObject("data") : response);
        return new ApiKey(data);
    }

    public JsonObject getApiKeyUsage(String keyId) throws SendlyException {
        if (keyId == null || keyId.isEmpty()) {
            throw new ValidationException("API key ID is required");
        }
        return this.client.get("/account/keys/" + keyId + "/usage", null);
    }

    public JsonObject createApiKey(String name, String type) throws SendlyException {
        return this.createApiKey(name, type, null);
    }

    public JsonObject createApiKey(String name, String type, List<String> scopes) throws SendlyException {
        if (name == null || name.isEmpty()) {
            throw new ValidationException("API key name is required");
        }
        if (type == null || !type.equals("test") && !type.equals("live")) {
            throw new ValidationException("API key type must be 'test' or 'live'");
        }
        JsonObject body = new JsonObject();
        body.addProperty("name", name);
        body.addProperty("type", type);
        if (scopes != null && !scopes.isEmpty()) {
            JsonArray scopesArray = new JsonArray();
            scopes.forEach(arg_0 -> ((JsonArray)scopesArray).add(arg_0));
            body.add("scopes", (JsonElement)scopesArray);
        }
        return this.client.post("/account/keys", body);
    }

    public ApiKey revokeApiKey(String keyId) throws SendlyException {
        return this.revokeApiKey(keyId, null);
    }

    public ApiKey revokeApiKey(String keyId, String reason) throws SendlyException {
        JsonObject response;
        if (keyId == null || keyId.isEmpty()) {
            throw new ValidationException("API key ID is required");
        }
        JsonObject body = new JsonObject();
        if (reason != null && !reason.isEmpty()) {
            body.addProperty("reason", reason);
        }
        JsonObject data = (response = this.client.patch("/account/keys/" + keyId + "/revoke", body)).has("key") ? response.getAsJsonObject("key") : (response.has("data") ? response.getAsJsonObject("data") : response);
        return new ApiKey(data);
    }
}

