/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class ApiKey {
    private final String id;
    private final String name;
    private final String type;
    private final String prefix;
    private final String lastFour;
    private final List<String> permissions;
    private final String createdAt;
    private final String lastUsedAt;
    private final String expiresAt;
    private final boolean isRevoked;

    public ApiKey(JsonObject json) {
        this.id = this.getStringOrNull(json, "id");
        this.name = this.getStringOrNull(json, "name");
        this.type = this.getStringOrNull(json, "type");
        this.prefix = this.getStringOrNull(json, "prefix");
        this.lastFour = this.getStringOrNull(json, "last_four", "lastFour");
        this.permissions = this.getStringList(json, "permissions");
        this.createdAt = this.getStringOrNull(json, "created_at", "createdAt");
        this.lastUsedAt = this.getStringOrNull(json, "last_used_at", "lastUsedAt");
        this.expiresAt = this.getStringOrNull(json, "expires_at", "expiresAt");
        this.isRevoked = this.getBoolOrDefault(json, "is_revoked", "isRevoked", false);
    }

    private String getStringOrNull(JsonObject json, String key) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
    }

    private String getStringOrNull(JsonObject json, String key1, String key2) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsString();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsString();
        }
        return null;
    }

    private boolean getBoolOrDefault(JsonObject json, String key1, String key2, boolean defaultVal) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsBoolean();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsBoolean();
        }
        return defaultVal;
    }

    private List<String> getStringList(JsonObject json, String key) {
        ArrayList<String> list = new ArrayList<String>();
        if (json.has(key) && json.get(key).isJsonArray()) {
            JsonArray arr = json.getAsJsonArray(key);
            for (int i = 0; i < arr.size(); ++i) {
                if (arr.get(i).isJsonNull()) continue;
                list.add(arr.get(i).getAsString());
            }
        }
        return list;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLastFour() {
        return this.lastFour;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getLastUsedAt() {
        return this.lastUsedAt;
    }

    public String getExpiresAt() {
        return this.expiresAt;
    }

    public boolean isRevoked() {
        return this.isRevoked;
    }

    public String toString() {
        return "ApiKey{id='" + this.id + "', name='" + this.name + "', type='" + this.type + "'}";
    }
}

