/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sendly.models.ScheduledMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ScheduledMessageList
implements Iterable<ScheduledMessage> {
    private final List<ScheduledMessage> messages = new ArrayList<ScheduledMessage>();
    private final int total;
    private final int limit;
    private final int offset;
    private final boolean hasMore;

    public ScheduledMessageList(JsonObject json) {
        JsonArray data = json.has("data") ? json.getAsJsonArray("data") : new JsonArray();
        for (JsonElement element : data) {
            this.messages.add(new ScheduledMessage(element.getAsJsonObject()));
        }
        this.total = json.has("total") ? json.get("total").getAsInt() : this.messages.size();
        this.limit = json.has("limit") ? json.get("limit").getAsInt() : 20;
        int n = this.offset = json.has("offset") ? json.get("offset").getAsInt() : 0;
        this.hasMore = json.has("has_more") ? json.get("has_more").getAsBoolean() : this.offset + this.messages.size() < this.total;
    }

    public List<ScheduledMessage> getData() {
        return this.messages;
    }

    public int getTotal() {
        return this.total;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public Iterator<ScheduledMessage> iterator() {
        return this.messages.iterator();
    }
}

