/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sendly.models.BatchMessageResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BatchList
implements Iterable<BatchMessageResponse> {
    private final List<BatchMessageResponse> batches = new ArrayList<BatchMessageResponse>();
    private final int total;
    private final int limit;
    private final int offset;
    private final boolean hasMore;

    public BatchList(JsonObject json) {
        JsonArray data = json.has("data") ? json.getAsJsonArray("data") : new JsonArray();
        for (JsonElement element : data) {
            this.batches.add(new BatchMessageResponse(element.getAsJsonObject()));
        }
        this.total = json.has("total") ? json.get("total").getAsInt() : this.batches.size();
        this.limit = json.has("limit") ? json.get("limit").getAsInt() : 20;
        int n = this.offset = json.has("offset") ? json.get("offset").getAsInt() : 0;
        this.hasMore = json.has("has_more") ? json.get("has_more").getAsBoolean() : this.offset + this.batches.size() < this.total;
    }

    public List<BatchMessageResponse> getData() {
        return this.batches;
    }

    public int getTotal() {
        return this.total;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public Iterator<BatchMessageResponse> iterator() {
        return this.batches.iterator();
    }
}

