/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.webhooks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Webhooks {
    private static final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").create();

    public static boolean verifySignature(String payload, String signature, String secret) {
        if (payload == null || signature == null || secret == null || payload.isEmpty() || signature.isEmpty() || secret.isEmpty()) {
            return false;
        }
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            mac.init(secretKeySpec);
            byte[] hash = mac.doFinal(payload.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            String expected = "sha256=" + hexString.toString();
            return MessageDigest.isEqual(signature.getBytes(StandardCharsets.UTF_8), expected.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            return false;
        }
    }

    public static WebhookEvent parseEvent(String payload, String signature, String secret) throws WebhookSignatureException {
        if (!Webhooks.verifySignature(payload, signature, secret)) {
            throw new WebhookSignatureException("Invalid webhook signature");
        }
        try {
            WebhookEvent event = (WebhookEvent)gson.fromJson(payload, WebhookEvent.class);
            if (event.getId() == null || event.getType() == null || event.getCreatedAt() == null) {
                throw new WebhookSignatureException("Invalid event structure");
            }
            return event;
        }
        catch (JsonSyntaxException e) {
            throw new WebhookSignatureException("Failed to parse webhook payload: " + e.getMessage());
        }
    }

    public static String generateSignature(String payload, String secret) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            mac.init(secretKeySpec);
            byte[] hash = mac.doFinal(payload.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return "sha256=" + hexString.toString();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to generate signature", e);
        }
    }

    public static class WebhookSignatureException
    extends Exception {
        public WebhookSignatureException(String message) {
            super(message);
        }
    }

    public static class WebhookEvent {
        private String id;
        private String type;
        private WebhookMessageData data;
        @SerializedName(value="created_at")
        private String createdAt;
        @SerializedName(value="api_version")
        private String apiVersion;

        public String getId() {
            return this.id;
        }

        public String getType() {
            return this.type;
        }

        public WebhookMessageData getData() {
            return this.data;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }
    }

    public static class WebhookMessageData {
        @SerializedName(value="message_id")
        private String messageId;
        private String status;
        private String to;
        private String from;
        private String error;
        @SerializedName(value="error_code")
        private String errorCode;
        @SerializedName(value="delivered_at")
        private String deliveredAt;
        @SerializedName(value="failed_at")
        private String failedAt;
        private int segments;
        @SerializedName(value="credits_used")
        private int creditsUsed;

        public String getMessageId() {
            return this.messageId;
        }

        public String getStatus() {
            return this.status;
        }

        public String getTo() {
            return this.to;
        }

        public String getFrom() {
            return this.from;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getDeliveredAt() {
            return this.deliveredAt;
        }

        public String getFailedAt() {
            return this.failedAt;
        }

        public int getSegments() {
            return this.segments;
        }

        public int getCreditsUsed() {
            return this.creditsUsed;
        }
    }
}

