/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchPreviewResponse {
    private final boolean canSend;
    private final int totalMessages;
    private final int willSend;
    private final int blocked;
    private final int creditsNeeded;
    private final int currentBalance;
    private final boolean hasEnoughCredits;
    private final List<BatchPreviewItem> messages;
    private final Map<String, Integer> blockReasons;

    public BatchPreviewResponse(JsonObject json) {
        this.canSend = json.has("canSend") && json.get("canSend").getAsBoolean();
        this.totalMessages = json.has("totalMessages") ? json.get("totalMessages").getAsInt() : 0;
        this.willSend = json.has("willSend") ? json.get("willSend").getAsInt() : 0;
        this.blocked = json.has("blocked") ? json.get("blocked").getAsInt() : 0;
        this.creditsNeeded = json.has("creditsNeeded") ? json.get("creditsNeeded").getAsInt() : 0;
        this.currentBalance = json.has("currentBalance") ? json.get("currentBalance").getAsInt() : 0;
        this.hasEnoughCredits = json.has("hasEnoughCredits") && json.get("hasEnoughCredits").getAsBoolean();
        this.messages = new ArrayList<BatchPreviewItem>();
        if (json.has("messages") && json.get("messages").isJsonArray()) {
            JsonArray messagesArray = json.getAsJsonArray("messages");
            for (JsonElement element : messagesArray) {
                this.messages.add(new BatchPreviewItem(element.getAsJsonObject()));
            }
        }
        this.blockReasons = new HashMap<String, Integer>();
        if (json.has("blockReasons") && json.get("blockReasons").isJsonObject()) {
            JsonObject reasons = json.getAsJsonObject("blockReasons");
            for (String key : reasons.keySet()) {
                this.blockReasons.put(key, reasons.get(key).getAsInt());
            }
        }
    }

    public boolean canSend() {
        return this.canSend;
    }

    public int getTotalMessages() {
        return this.totalMessages;
    }

    public int getWillSend() {
        return this.willSend;
    }

    public int getBlocked() {
        return this.blocked;
    }

    public int getCreditsNeeded() {
        return this.creditsNeeded;
    }

    public int getCurrentBalance() {
        return this.currentBalance;
    }

    public boolean hasEnoughCredits() {
        return this.hasEnoughCredits;
    }

    public List<BatchPreviewItem> getMessages() {
        return this.messages;
    }

    public Map<String, Integer> getBlockReasons() {
        return this.blockReasons;
    }

    public String toString() {
        return "BatchPreviewResponse{canSend=" + this.canSend + ", totalMessages=" + this.totalMessages + ", willSend=" + this.willSend + ", blocked=" + this.blocked + ", creditsNeeded=" + this.creditsNeeded + ", currentBalance=" + this.currentBalance + ", hasEnoughCredits=" + this.hasEnoughCredits + "}";
    }

    public static class BatchPreviewItem {
        private final String to;
        private final String text;
        private final int segments;
        private final int credits;
        private final boolean canSend;
        private final String blockReason;
        private final String country;
        private final String pricingTier;

        public BatchPreviewItem(JsonObject json) {
            this.to = this.getStringOrNull(json, "to");
            this.text = this.getStringOrNull(json, "text");
            this.segments = json.has("segments") ? json.get("segments").getAsInt() : 1;
            this.credits = json.has("credits") ? json.get("credits").getAsInt() : 0;
            this.canSend = json.has("canSend") && json.get("canSend").getAsBoolean();
            this.blockReason = this.getStringOrNull(json, "blockReason");
            this.country = this.getStringOrNull(json, "country");
            this.pricingTier = this.getStringOrNull(json, "pricingTier");
        }

        private String getStringOrNull(JsonObject json, String key) {
            return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
        }

        public String getTo() {
            return this.to;
        }

        public String getText() {
            return this.text;
        }

        public int getSegments() {
            return this.segments;
        }

        public int getCredits() {
            return this.credits;
        }

        public boolean canSend() {
            return this.canSend;
        }

        public String getBlockReason() {
            return this.blockReason;
        }

        public String getCountry() {
            return this.country;
        }

        public String getPricingTier() {
            return this.pricingTier;
        }

        public String toString() {
            return "BatchPreviewItem{to='" + this.to + "', segments=" + this.segments + ", credits=" + this.credits + ", canSend=" + this.canSend + "}";
        }
    }
}

