/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.sendly.models.BatchMessageItem;
import java.util.ArrayList;
import java.util.List;

public class SendBatchRequest {
    private final List<BatchMessageItem> messages;
    private final String from;
    private final String messageType;

    public SendBatchRequest(List<BatchMessageItem> messages) {
        this(messages, null, null);
    }

    public SendBatchRequest(List<BatchMessageItem> messages, String from) {
        this(messages, from, null);
    }

    public SendBatchRequest(List<BatchMessageItem> messages, String from, String messageType) {
        this.messages = messages;
        this.from = from;
        this.messageType = messageType;
    }

    public List<BatchMessageItem> getMessages() {
        return this.messages;
    }

    public String getFrom() {
        return this.from;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<BatchMessageItem> messages = new ArrayList<BatchMessageItem>();
        private String from;
        private String messageType;

        public Builder addMessage(String to, String text) {
            this.messages.add(new BatchMessageItem(to, text));
            return this;
        }

        public Builder addMessage(BatchMessageItem item) {
            this.messages.add(item);
            return this;
        }

        public Builder messages(List<BatchMessageItem> messages) {
            this.messages = messages;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        public SendBatchRequest build() {
            return new SendBatchRequest(this.messages, this.from, this.messageType);
        }
    }
}

