/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.models;

import com.google.gson.JsonObject;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public class WebhookDelivery {
    public static final String STATUS_PENDING = "pending";
    public static final String STATUS_DELIVERED = "delivered";
    public static final String STATUS_FAILED = "failed";
    public static final String STATUS_CANCELLED = "cancelled";
    private final String id;
    private final String webhookId;
    private final String eventId;
    private final String eventType;
    private final int attemptNumber;
    private final int maxAttempts;
    private final String status;
    private final Integer responseStatusCode;
    private final Integer responseTimeMs;
    private final String errorMessage;
    private final String errorCode;
    private final Instant nextRetryAt;
    private final Instant createdAt;
    private final Instant deliveredAt;

    public WebhookDelivery(JsonObject json) {
        this.id = this.getStringOrNull(json, "id");
        this.webhookId = this.getStringOrNull(json, "webhook_id", "webhookId");
        this.eventId = this.getStringOrNull(json, "event_id", "eventId");
        this.eventType = this.getStringOrNull(json, "event_type", "eventType");
        this.attemptNumber = this.getIntOrDefault(json, "attempt_number", "attemptNumber", 1);
        this.maxAttempts = this.getIntOrDefault(json, "max_attempts", "maxAttempts", 6);
        this.status = this.getStringOrNull(json, "status");
        this.responseStatusCode = this.getIntegerOrNull(json, "response_status_code", "responseStatusCode");
        this.responseTimeMs = this.getIntegerOrNull(json, "response_time_ms", "responseTimeMs");
        this.errorMessage = this.getStringOrNull(json, "error_message", "errorMessage");
        this.errorCode = this.getStringOrNull(json, "error_code", "errorCode");
        this.nextRetryAt = this.parseInstant(this.getStringOrNull(json, "next_retry_at", "nextRetryAt"));
        this.createdAt = this.parseInstant(this.getStringOrNull(json, "created_at", "createdAt"));
        this.deliveredAt = this.parseInstant(this.getStringOrNull(json, "delivered_at", "deliveredAt"));
    }

    private String getStringOrNull(JsonObject json, String key) {
        return json.has(key) && !json.get(key).isJsonNull() ? json.get(key).getAsString() : null;
    }

    private String getStringOrNull(JsonObject json, String key1, String key2) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsString();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsString();
        }
        return null;
    }

    private int getIntOrDefault(JsonObject json, String key1, String key2, int defaultVal) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsInt();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsInt();
        }
        return defaultVal;
    }

    private Integer getIntegerOrNull(JsonObject json, String key1, String key2) {
        if (json.has(key1) && !json.get(key1).isJsonNull()) {
            return json.get(key1).getAsInt();
        }
        if (json.has(key2) && !json.get(key2).isJsonNull()) {
            return json.get(key2).getAsInt();
        }
        return null;
    }

    private Instant parseInstant(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Instant.parse(value);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getWebhookId() {
        return this.webhookId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getResponseStatusCode() {
        return this.responseStatusCode;
    }

    public Integer getResponseTimeMs() {
        return this.responseTimeMs;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Instant getNextRetryAt() {
        return this.nextRetryAt;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getDeliveredAt() {
        return this.deliveredAt;
    }

    public boolean isDelivered() {
        return STATUS_DELIVERED.equals(this.status);
    }

    public boolean isFailed() {
        return STATUS_FAILED.equals(this.status);
    }

    public String toString() {
        return "WebhookDelivery{id='" + this.id + "', eventType='" + this.eventType + "', status='" + this.status + "'}";
    }
}

