/*
 * Decompiled with CFR 0.152.
 */
package com.sendly.resources;

import com.sendly.Sendly;
import com.sendly.exceptions.SendlyException;
import com.sendly.models.Template;
import com.sendly.models.TemplateListResponse;
import com.sendly.models.TemplatePreview;
import java.util.HashMap;
import java.util.Map;

public class TemplatesResource {
    private final Sendly client;

    public TemplatesResource(Sendly client) {
        this.client = client;
    }

    public TemplateListResponse list() throws SendlyException {
        return this.client.request("GET", "/templates", null, TemplateListResponse.class);
    }

    public TemplateListResponse presets() throws SendlyException {
        return this.client.request("GET", "/templates/presets", null, TemplateListResponse.class);
    }

    public Template get(String templateId) throws SendlyException {
        return this.client.request("GET", "/templates/" + templateId, null, Template.class);
    }

    public Template create(String name, String text) throws SendlyException {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("name", name);
        body.put("text", text);
        return this.client.request("POST", "/templates", body, Template.class);
    }

    public Template update(String templateId, String name, String text) throws SendlyException {
        HashMap<String, String> body = new HashMap<String, String>();
        if (name != null) {
            body.put("name", name);
        }
        if (text != null) {
            body.put("text", text);
        }
        return this.client.request("PATCH", "/templates/" + templateId, body, Template.class);
    }

    public Template publish(String templateId) throws SendlyException {
        return this.client.request("POST", "/templates/" + templateId + "/publish", null, Template.class);
    }

    public void delete(String templateId) throws SendlyException {
        this.client.request("DELETE", "/templates/" + templateId, null, Void.class);
    }

    public TemplatePreview preview(String templateId, Map<String, String> variables) throws SendlyException {
        HashMap<String, Map<String, String>> body = new HashMap<String, Map<String, String>>();
        if (variables != null) {
            body.put("variables", variables);
        }
        return this.client.request("POST", "/templates/" + templateId + "/preview", body, TemplatePreview.class);
    }
}

