package net.adamcin.httpsig.api;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * Immutable interface for a list of {@link Key}s
 */
public interface Keychain extends Iterable<Key> {

    /**
     * @return a {@link Set} containing the union of all algorithms supported by each {@link Key} in this {@link Keychain}
     */
    Set<Algorithm> getAlgorithms();

    /**
     * Filter this keychain by a {@link Collection} of supported {@link Algorithm}s
     * @param algorithms
     * @return a new {@link Keychain} containing only those keys which support at least one of the provided algorithms
     */
    Keychain filterAlgorithms(Collection<Algorithm> algorithms);

    /**
     * @return a reference to a {@link Keychain} which excludes the current {@link Key}.
     */
    Keychain discard();

    /**
     * @return a reference to the current {@link Key}.
     */
    Key currentKey();

    /**
     * @param keyIdentifier
     * @return a {@link Map} where the values are the {@link Key}s and the map entry keys are the keyId's generated by the {@link KeyIdentifier}, o
     */
    Map<String, Key> toMap(KeyIdentifier keyIdentifier);

    /**
     * @return true if this {@link Keychain} has no more keys
     */
    boolean isEmpty();
}
