/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.Base64;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Authorization
implements Serializable {
    private final String keyId;
    private final String signature;
    private final List<String> headers;
    private final Algorithm algorithm;
    private final Challenge challenge;

    public Authorization(String keyId, String signature, List<String> headers, Algorithm algorithm) {
        this(keyId, signature, headers, algorithm, null);
    }

    public Authorization(String keyId, String signature, List<String> headers, Algorithm algorithm, Challenge challenge) {
        this.keyId = keyId;
        this.signature = signature;
        this.headers = headers != null ? Collections.unmodifiableList(new ArrayList<String>(headers)) : Collections.emptyList();
        this.algorithm = algorithm;
        this.challenge = challenge != null ? challenge : Constants.PREEMPTIVE_CHALLENGE;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getSignature() {
        return this.signature;
    }

    public byte[] getSignatureBytes() {
        return Base64.fromBase64String(this.signature);
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Challenge getChallenge() {
        return this.challenge;
    }

    public String getHeaderValue() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("keyId", this.keyId);
        params.put("signature", this.signature);
        params.put("headers", Constants.constructTokensString(this.getHeaders()));
        params.put("algorithm", this.algorithm.getName());
        return Constants.constructRFC2617(params);
    }

    public String toString() {
        return this.getHeaderValue();
    }

    public static Authorization parse(String header) {
        if (header == null) {
            return null;
        }
        Map<String, String> params = Constants.parseRFC2617(header);
        if (params.containsKey("keyId") && params.containsKey("headers") && params.containsKey("signature") && params.containsKey("algorithm")) {
            String keyId = params.get("keyId");
            String signature = params.get("signature");
            String headers = params.get("headers");
            String algorithm = params.get("algorithm");
            return new Authorization(keyId, signature, Constants.parseTokens(headers), Algorithm.forName(algorithm));
        }
        return null;
    }
}

