/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SignatureBuilder
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(SignatureBuilder.class.getName());
    public static final String DATE_FORMAT = "EEE MMM d HH:mm:ss yyyy zzz";
    private String requestLine = null;
    private final Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();

    public byte[] buildContent(List<String> headers, Charset charset) {
        return this.buildString(headers).getBytes(charset);
    }

    public String buildString(List<String> headers) {
        StringBuilder hashBuilder = new StringBuilder("");
        if (headers != null) {
            for (String header : headers) {
                String _header = header.toLowerCase();
                if ("request-line".equals(_header)) {
                    if (this.requestLine == null) continue;
                    hashBuilder.append(this.requestLine).append("\n");
                    continue;
                }
                for (String value : this.getHeaderValues(_header)) {
                    hashBuilder.append(_header).append(": ").append(value).append("\n");
                }
            }
        }
        return hashBuilder.toString().trim();
    }

    public String toString() {
        return this.buildString(this.getHeaderNames());
    }

    public List<String> getHeaderNames() {
        ArrayList<String> headerNames = new ArrayList<String>();
        if (this.requestLine != null) {
            headerNames.add("request-line");
        }
        headerNames.addAll(this.headers.keySet());
        return Collections.unmodifiableList(headerNames);
    }

    public boolean setRequestLine(String requestLine) {
        if (this.requestLine == null) {
            this.requestLine = requestLine;
            return true;
        }
        return false;
    }

    public boolean addHeader(String name, String value) {
        String _name = name.toLowerCase();
        if (_name.equals("Authorization".toLowerCase()) || _name.startsWith(":")) {
            return false;
        }
        if ("request-line".equals(_name)) {
            return false;
        }
        if (!"date".equals(_name) || this.tryParseDate(value)) {
            ArrayList<String> values = null;
            if (this.headers.containsKey(_name)) {
                this.headers.get(_name);
            } else {
                values = new ArrayList<String>();
                this.headers.put(_name, values);
            }
            return values.add(value);
        }
        return false;
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public String getDate() {
        List<String> dateValues = this.getHeaderValues("date");
        return dateValues.isEmpty() ? null : dateValues.get(0);
    }

    public List<String> getHeaderValues(String name) {
        String _name = name.toLowerCase();
        if ("request-line".equals(_name)) {
            return this.requestLine != null ? Collections.singletonList(this.requestLine) : Collections.emptyList();
        }
        if (this.headers.containsKey(_name)) {
            return Collections.unmodifiableList(this.headers.get(_name));
        }
        return Collections.emptyList();
    }

    public boolean tryParseDate(String date) {
        if (date != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
                dateFormat.parse(date);
                return true;
            }
            catch (ParseException e) {
                LOGGER.warning("[addDate] date string " + date + " does not match format " + DATE_FORMAT);
            }
        }
        return false;
    }

    public boolean addDate(Calendar calendar) {
        if (calendar != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            dateFormat.setTimeZone(calendar.getTimeZone());
            return this.addHeader("date", dateFormat.format(calendar.getTime()));
        }
        return false;
    }

    public boolean addDate(Date dateGMT) {
        if (dateGMT != null) {
            GregorianCalendar calendar = new GregorianCalendar(SignatureBuilder.getGMT());
            calendar.setTime(dateGMT);
            return this.addDate(calendar);
        }
        return false;
    }

    public boolean addDateNow() {
        return this.addDate(new GregorianCalendar(SignatureBuilder.getGMT()));
    }

    public Date getDateGMT() {
        if (this.getDate() != null) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
                dateFormat.setTimeZone(SignatureBuilder.getGMT());
                return dateFormat.parse(this.getDate());
            }
            catch (ParseException e) {
                LOGGER.warning("[getDateGMT] date string " + this.getDate() + " does not match format " + DATE_FORMAT);
            }
        }
        return null;
    }

    public Calendar getDateTZ(TimeZone timeZone) {
        TimeZone tz;
        Date dateGMT = this.getDateGMT();
        TimeZone timeZone2 = tz = timeZone != null ? timeZone : TimeZone.getDefault();
        if (dateGMT != null) {
            GregorianCalendar calGMT = new GregorianCalendar(SignatureBuilder.getGMT());
            calGMT.setTime(dateGMT);
            return SignatureBuilder.convertDate(calGMT, tz);
        }
        return null;
    }

    private static TimeZone getGMT() {
        return TimeZone.getTimeZone("UTC");
    }

    private static Calendar convertDate(Calendar orig, TimeZone to) {
        GregorianCalendar calendar = new GregorianCalendar(orig.getTimeZone());
        calendar.setTime(orig.getTime());
        ((Calendar)calendar).add(14, ((Calendar)calendar).getTimeZone().getRawOffset() * -1);
        if (((Calendar)calendar).getTimeZone().inDaylightTime(calendar.getTime())) {
            ((Calendar)calendar).add(14, ((Calendar)calendar).getTimeZone().getDSTSavings() * -1);
        }
        ((Calendar)calendar).add(14, to.getRawOffset());
        if (to.inDaylightTime(calendar.getTime())) {
            ((Calendar)calendar).add(14, to.getDSTSavings());
        }
        ((Calendar)calendar).setTimeZone(to);
        return calendar;
    }
}

