/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.Authorization;
import net.adamcin.httpsig.api.Base64;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.Constants;
import net.adamcin.httpsig.api.DefaultKeychain;
import net.adamcin.httpsig.api.Key;
import net.adamcin.httpsig.api.KeyIdentifier;
import net.adamcin.httpsig.api.Keychain;
import net.adamcin.httpsig.api.SignatureBuilder;

public final class Signer {
    private KeyIdentifier keyIdentifier;
    private Keychain keychain;
    private Keychain candidateKeys;
    private Challenge challenge = Constants.PREEMPTIVE_CHALLENGE;

    public Signer() {
        this(null, null);
    }

    public Signer(Keychain keychain) {
        this(keychain, null);
    }

    public Signer(Keychain keychain, KeyIdentifier keyIdentifier) {
        this.keychain = keychain != null ? keychain : new DefaultKeychain();
        this.keyIdentifier = keyIdentifier != null ? keyIdentifier : Constants.DEFAULT_KEY_IDENTIFIER;
        this.candidateKeys = this.keychain.filterAlgorithms(this.challenge.getAlgorithms());
        this.rotateUntilCanSign();
    }

    private synchronized void rotateUntilCanSign() {
        while (!this.candidateKeys.isEmpty() && !this.candidateKeys.currentKey().canSign()) {
            this.candidateKeys = this.candidateKeys.discard();
        }
    }

    public Keychain getKeychain() {
        return this.keychain;
    }

    public Keychain getCandidateKeys() {
        return this.candidateKeys;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public synchronized boolean rotateKeys() {
        return this.rotateKeys(Constants.PREEMPTIVE_CHALLENGE);
    }

    public synchronized boolean rotateKeys(Challenge nextChallenge) {
        return this.rotateKeys(nextChallenge, null);
    }

    public synchronized boolean rotateKeys(Challenge nextChallenge, Authorization failedAuthz) {
        if (nextChallenge == null) {
            throw new IllegalArgumentException("nextChallenge cannot be null");
        }
        if (this.challenge.equals(nextChallenge)) {
            if (!this.candidateKeys.isEmpty() && failedAuthz != null && this.keyIdentifier.getId(this.candidateKeys.currentKey()).equals(failedAuthz.getKeyId())) {
                this.candidateKeys = this.candidateKeys.discard();
            }
        } else {
            this.candidateKeys = this.keychain.filterAlgorithms(nextChallenge.getAlgorithms());
        }
        this.rotateUntilCanSign();
        this.challenge = nextChallenge;
        return !this.candidateKeys.isEmpty();
    }

    public Authorization sign(SignatureBuilder signatureBuilder) {
        if (!this.candidateKeys.isEmpty()) {
            Key key = this.candidateKeys.currentKey();
            Algorithm algo = null;
            for (Algorithm algorithm : key.getAlgorithms()) {
                if (!this.challenge.getAlgorithms().contains((Object)algorithm)) continue;
                algo = algorithm;
                break;
            }
            LinkedHashSet<String> signHeaders = new LinkedHashSet<String>();
            signHeaders.addAll(this.challenge.getHeaders());
            ArrayList<String> headers = new ArrayList<String>(signHeaders);
            byte[] signature = key.sign(algo, signatureBuilder.buildContent(headers, Constants.CHARSET));
            if (signature != null) {
                return new Authorization(this.keyIdentifier.getId(key), Base64.toBase64String(signature), headers, algo, this.challenge);
            }
        }
        return null;
    }
}

