/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Challenge
implements Serializable {
    private static final long serialVersionUID = 4044394118184261470L;
    private final String realm;
    private final List<String> headers;
    private final List<Algorithm> algorithms;

    public Challenge(String realm, List<String> headers, Collection<Algorithm> algorithms) {
        this.realm = realm;
        this.headers = headers != null ? Constants.filterHeaders(new ArrayList<String>(headers)) : Constants.DEFAULT_HEADERS;
        this.algorithms = algorithms != null ? Arrays.asList(algorithms.toArray(new Algorithm[algorithms.size()])) : Collections.emptyList();
    }

    public String getRealm() {
        return this.realm;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public List<Algorithm> getAlgorithms() {
        return this.algorithms;
    }

    public String getHeaderValue() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("realm", this.realm);
        params.put("headers", Constants.constructTokensString(this.getHeaders()));
        params.put("algorithms", this.getAlgorithmsString());
        return Constants.constructRFC2617(params);
    }

    public String getAlgorithmsString() {
        if (this.algorithms == null || this.algorithms.isEmpty()) {
            return "";
        }
        StringBuilder _algos = new StringBuilder();
        for (Algorithm algo : this.algorithms) {
            _algos.append(algo.getName()).append(" ");
        }
        return _algos.toString();
    }

    public String toString() {
        return this.getHeaderValue();
    }

    public static List<Algorithm> parseAlgorithms(String algorithms) {
        List<String> tokens = Constants.parseTokens(algorithms);
        ArrayList<Algorithm> algorithmList = new ArrayList<Algorithm>();
        for (String token : tokens) {
            Algorithm algorithm = Algorithm.forName(token);
            if (algorithm == null) continue;
            algorithmList.add(algorithm);
        }
        return Collections.unmodifiableList(algorithmList);
    }

    public static Challenge parse(String header) {
        Map<String, String> params;
        if (header != null && header.toLowerCase().startsWith("Signature".toLowerCase()) && (params = Constants.parseRFC2617(header)).containsKey("realm") && params.containsKey("algorithms")) {
            String realm = params.get("realm");
            String algorithms = params.get("algorithms");
            String headers = params.get("headers");
            return new Challenge(realm, headers != null ? Constants.parseTokens(headers) : Constants.DEFAULT_HEADERS, Challenge.parseAlgorithms(algorithms));
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Challenge challenge = (Challenge)o;
        if (!this.algorithms.equals(challenge.algorithms)) {
            return false;
        }
        if (!this.headers.equals(challenge.headers)) {
            return false;
        }
        return this.realm.equals(challenge.realm);
    }

    public int hashCode() {
        int result = this.realm.hashCode();
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + this.algorithms.hashCode();
        return result;
    }
}

