/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.Base64;
import net.adamcin.httpsig.api.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Authorization
implements Serializable {
    private static final long serialVersionUID = -5642537789425001043L;
    private final String keyId;
    private final String signature;
    private final List<String> headers;
    private final Algorithm algorithm;

    public Authorization(String keyId, String signature, List<String> headers, Algorithm algorithm) {
        this.keyId = keyId;
        this.signature = signature;
        this.headers = headers != null ? Constants.filterHeaders(new ArrayList<String>(headers)) : Constants.DEFAULT_HEADERS;
        this.algorithm = algorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getSignature() {
        return this.signature;
    }

    public byte[] getSignatureBytes() {
        return Base64.fromBase64String(this.signature);
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getHeaderValue() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("keyId", this.keyId);
        params.put("signature", this.signature);
        params.put("headers", Constants.constructTokensString(this.getHeaders()));
        params.put("algorithm", this.algorithm.getName());
        return Constants.constructRFC2617(params);
    }

    public String toString() {
        return this.getHeaderValue();
    }

    public static Authorization parse(String header) {
        Map<String, String> params;
        if (header != null && header.toLowerCase().startsWith("Signature".toLowerCase()) && (params = Constants.parseRFC2617(header)).containsKey("keyId") && params.containsKey("signature") && params.containsKey("algorithm")) {
            String keyId = params.get("keyId");
            String signature = params.get("signature");
            String algorithm = params.get("algorithm");
            String headers = params.get("headers");
            return new Authorization(keyId, signature, headers != null ? Constants.parseTokens(headers) : Constants.DEFAULT_HEADERS, Algorithm.forName(algorithm));
        }
        return null;
    }
}

