/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.adamcin.httpsig.api.Algorithm;
import net.adamcin.httpsig.api.Authorization;
import net.adamcin.httpsig.api.Challenge;
import net.adamcin.httpsig.api.Constants;
import net.adamcin.httpsig.api.DefaultKeychain;
import net.adamcin.httpsig.api.Key;
import net.adamcin.httpsig.api.KeyId;
import net.adamcin.httpsig.api.Keychain;
import net.adamcin.httpsig.api.RequestContent;
import net.adamcin.httpsig.api.Verifier;
import net.adamcin.httpsig.api.VerifyResult;

public final class DefaultVerifier
implements Verifier {
    public static final long DEFAULT_SKEW = 300000L;
    private final Keychain keychain;
    private final KeyId keyId;
    private final long skew;

    public DefaultVerifier(Keychain keychain) {
        this(keychain, null, 300000L);
    }

    public DefaultVerifier(Keychain keychain, KeyId keyId) {
        this(keychain, keyId, 300000L);
    }

    public DefaultVerifier(Keychain keychain, KeyId keyId, long skew) {
        this.keychain = keychain != null ? new KeychainGuard(keychain) : new KeychainGuard(new DefaultKeychain());
        this.keyId = new CanVerifyId(keyId != null ? keyId : Constants.DEFAULT_KEY_IDENTIFIER);
        this.skew = skew;
    }

    public Keychain getKeychain() {
        return this.keychain;
    }

    public long getSkew() {
        return this.skew;
    }

    public void setSkew(long skew) {
    }

    public Key selectKey(Authorization authorization) {
        return this.keychain.toMap(this.keyId).get(authorization.getKeyId());
    }

    public boolean verify(Challenge challenge, RequestContent requestContent, Authorization authorization) {
        return this.verifyWithResult(challenge, requestContent, authorization) == VerifyResult.SUCCESS;
    }

    public VerifyResult verifyWithResult(Challenge challenge, RequestContent requestContent, Authorization authorization) {
        Key key;
        if (challenge == null) {
            throw new IllegalArgumentException("challenge cannot be null");
        }
        if (requestContent == null) {
            throw new IllegalArgumentException("requestContent cannot be null");
        }
        if (authorization == null) {
            throw new IllegalArgumentException("authorization cannot be null");
        }
        for (String header : challenge.getHeaders()) {
            if (header.startsWith(":") || authorization.getHeaders().contains(header)) continue;
            return VerifyResult.CHALLENGE_NOT_SATISFIED;
        }
        for (String header : authorization.getHeaders()) {
            if (!requestContent.getHeaderValues(header).isEmpty()) continue;
            return VerifyResult.INCOMPLETE_REQUEST;
        }
        if (authorization.getHeaders().contains("date") && this.skew >= 0L) {
            Date requestTime = requestContent.getDateGMT();
            Date currentTime = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
            Date past = new Date(currentTime.getTime() - this.skew);
            Date future = new Date(currentTime.getTime() + this.skew);
            if (requestTime.before(past) || requestTime.after(future)) {
                return VerifyResult.EXPIRED_DATE_HEADER;
            }
        }
        if ((key = this.selectKey(authorization)) == null) {
            return VerifyResult.KEY_NOT_FOUND;
        }
        if (key.verify(authorization.getAlgorithm(), requestContent.getContent(authorization.getHeaders(), Constants.CHARSET), authorization.getSignatureBytes())) {
            return VerifyResult.SUCCESS;
        }
        return VerifyResult.FAILED_KEY_VERIFY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeychainGuard
    implements Keychain {
        private final Keychain keychain;

        private KeychainGuard(Keychain keychain) {
            this.keychain = keychain;
        }

        @Override
        public Set<Algorithm> getAlgorithms() {
            return this.keychain.getAlgorithms();
        }

        @Override
        public Keychain filterAlgorithms(Collection<Algorithm> algorithms) {
            return new KeychainGuard(this.keychain.filterAlgorithms(algorithms));
        }

        @Override
        public Keychain discard() {
            return new KeychainGuard(this.keychain.discard());
        }

        @Override
        public Key currentKey() {
            return this.keychain.currentKey();
        }

        @Override
        public Map<String, Key> toMap(KeyId keyId) {
            return this.keychain.toMap(keyId);
        }

        @Override
        public boolean isEmpty() {
            return this.keychain.isEmpty();
        }

        @Override
        public Iterator<Key> iterator() {
            return this.keychain.iterator();
        }
    }

    private static class CanVerifyId
    implements KeyId {
        private KeyId delegatee;

        private CanVerifyId(KeyId delegatee) {
            this.delegatee = delegatee;
        }

        public String getId(Key key) {
            if (key != null && key.canVerify()) {
                return this.delegatee.getId(key);
            }
            return null;
        }
    }
}

