/*
 * Decompiled with CFR 0.152.
 */
package net.adamcin.httpsig.api;

public enum Algorithm {
    RSA_SHA1("rsa-sha1"),
    RSA_SHA256("rsa-sha256"),
    RSA_SHA512("rsa-sha512"),
    DSA_SHA1("dsa-sha1"),
    HMAC_SHA1("hmac-sha1"),
    HMAC_SHA256("hmac-sha256"),
    HMAC_SHA512("hmac-sha512"),
    SSH_RSA("ssh-rsa"),
    SSH_DSS("ssh-dss");

    private final String name;

    private Algorithm(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Algorithm forName(String name) {
        for (Algorithm algorithm : Algorithm.values()) {
            if (!algorithm.getName().equalsIgnoreCase(name)) continue;
            return algorithm;
        }
        return null;
    }
}

